/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import java.util.Comparator;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammerManager;
import jmri.CommandStation;
import jmri.ConsistManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.Programmer;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.easydcc.EasyDccCommandStation;
import jmri.jmrix.easydcc.EasyDccConsistManager;
import jmri.jmrix.easydcc.EasyDccPowerManager;
import jmri.jmrix.easydcc.EasyDccProgrammer;
import jmri.jmrix.easydcc.EasyDccProgrammerManager;
import jmri.jmrix.easydcc.EasyDccThrottleManager;
import jmri.jmrix.easydcc.EasyDccTrafficController;
import jmri.jmrix.easydcc.EasyDccTurnoutManager;
import jmri.jmrix.easydcc.swing.EasyDccComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.managers.DefaultProgrammerManager;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyDccSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    ComponentFactory cf = null;
    private EasyDccTrafficController et;
    private static final Logger log = LoggerFactory.getLogger(EasyDccSystemConnectionMemo.class);

    public EasyDccSystemConnectionMemo() {
        this("E", "Easy DCC");
    }

    public EasyDccSystemConnectionMemo(EasyDccTrafficController et) {
        super("E", "Easy DCC");
        this.et = et;
        log.debug("EasyDCC SystemConnectionMemo with TC");
        InstanceManager.store(this, EasyDccSystemConnectionMemo.class);
        this.cf = new EasyDccComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
        log.debug("Created EasyDccSystemConnectionMemo");
    }

    public EasyDccSystemConnectionMemo(@Nonnull String prefix, @Nonnull String name) {
        super(prefix, name);
        log.debug("EasyDCC SystemConnectionMemo prefix={}", (Object)prefix);
        InstanceManager.store(this, EasyDccSystemConnectionMemo.class);
        this.cf = new EasyDccComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
        log.debug("Created EasyDccSystemConnectionMemo");
    }

    public EasyDccTrafficController getTrafficController() {
        if (this.et == null) {
            this.setEasyDccTrafficController(new EasyDccTrafficController(this));
            log.debug("Auto create of EasyDccTrafficController for initial configuration");
        }
        return this.et;
    }

    public void setEasyDccTrafficController(EasyDccTrafficController et) {
        this.et = et;
        et.setSystemConnectionMemo(this);
    }

    @Override
    public void configureManagers() {
        InstanceManager.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
        InstanceManager.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
        InstanceManager.store(this.getPowerManager(), PowerManager.class);
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        InstanceManager.setThrottleManager(this.getThrottleManager());
        InstanceManager.store(this.getConsistManager(), ConsistManager.class);
        EasyDccCommandStation commandStation = new EasyDccCommandStation(this);
        InstanceManager.store(commandStation, CommandStation.class);
        this.store(commandStation, CommandStation.class);
        this.register();
    }

    public EasyDccPowerManager getPowerManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (EasyDccPowerManager)this.classObjectMap.computeIfAbsent(PowerManager.class, c -> new EasyDccPowerManager(this));
    }

    public ThrottleManager getThrottleManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (ThrottleManager)this.classObjectMap.computeIfAbsent(ThrottleManager.class, c -> new EasyDccThrottleManager(this));
    }

    public void setThrottleManager(ThrottleManager t) {
        this.store(t, ThrottleManager.class);
    }

    public EasyDccTurnoutManager getTurnoutManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (EasyDccTurnoutManager)this.classObjectMap.computeIfAbsent(TurnoutManager.class, c -> new EasyDccTurnoutManager(this));
    }

    @Override
    public EasyDccConsistManager getConsistManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (EasyDccConsistManager)this.classObjectMap.computeIfAbsent(ConsistManager.class, c -> new EasyDccConsistManager(this));
    }

    public EasyDccProgrammerManager getProgrammerManager() {
        return (EasyDccProgrammerManager)this.classObjectMap.computeIfAbsent(DefaultProgrammerManager.class, c -> new EasyDccProgrammerManager((Programmer)new EasyDccProgrammer(this), this));
    }

    public void setProgrammerManager(EasyDccProgrammerManager p) {
        this.store(p, DefaultProgrammerManager.class);
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.easydcc.EasyDccActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public boolean provides(Class<?> c) {
        if (!this.getDisabled() && c.equals(ConsistManager.class)) {
            return true;
        }
        return super.provides(c);
    }

    @Override
    public void dispose() {
        this.et = null;
        InstanceManager.deregister(this, EasyDccSystemConnectionMemo.class);
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
        }
        super.dispose();
    }
}

