/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.NmraPacket;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.easydcc.EasyDccMessage;
import jmri.jmrix.easydcc.EasyDccSystemConnectionMemo;
import jmri.jmrix.easydcc.EasyDccTrafficController;

public class EasyDccThrottle
extends AbstractThrottle {
    private final DccLocoAddress address;
    EasyDccTrafficController tc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EasyDccThrottle(EasyDccSystemConnectionMemo memo, DccLocoAddress address) {
        super(memo);
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
        this.tc = memo.getTrafficController();
        EasyDccThrottle easyDccThrottle = this;
        synchronized (easyDccThrottle) {
            this.speedSetting = 0.0f;
        }
        this.address = address;
        this.isForward = true;
    }

    @Override
    protected void sendFunctionGroup1() {
        byte[] result = NmraPacket.function0Through4Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunction(0), this.getFunction(1), this.getFunction(2), this.getFunction(3), this.getFunction(4));
        EasyDccMessage m = new EasyDccMessage(4 + 3 * result.length);
        int i = 0;
        m.setElement(i++, 83);
        m.setElement(i++, 32);
        m.setElement(i++, 48);
        m.setElement(i++, 49);
        for (int j = 0; j < result.length; ++j) {
            m.setElement(i++, 32);
            m.addIntAsTwoHex(result[j] & 0xFF, i);
            i += 2;
        }
        this.tc.sendEasyDccMessage(m, null);
    }

    @Override
    protected void sendFunctionGroup2() {
        byte[] result = NmraPacket.function5Through8Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunction(5), this.getFunction(6), this.getFunction(7), this.getFunction(8));
        EasyDccMessage m = new EasyDccMessage(4 + 3 * result.length);
        int i = 0;
        m.setElement(i++, 83);
        m.setElement(i++, 32);
        m.setElement(i++, 48);
        m.setElement(i++, 49);
        for (int j = 0; j < result.length; ++j) {
            m.setElement(i++, 32);
            m.addIntAsTwoHex(result[j] & 0xFF, i);
            i += 2;
        }
        this.tc.sendEasyDccMessage(m, null);
    }

    @Override
    protected void sendFunctionGroup3() {
        byte[] result = NmraPacket.function9Through12Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunction(9), this.getFunction(10), this.getFunction(11), this.getFunction(12));
        EasyDccMessage m = new EasyDccMessage(4 + 3 * result.length);
        int i = 0;
        m.setElement(i++, 83);
        m.setElement(i++, 32);
        m.setElement(i++, 48);
        m.setElement(i++, 49);
        for (int j = 0; j < result.length; ++j) {
            m.setElement(i++, 32);
            m.addIntAsTwoHex(result[j] & 0xFF, i);
            i += 2;
        }
        this.tc.sendEasyDccMessage(m, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public void setSpeedSetting(float speed) {
        byte[] result;
        int value;
        float oldSpeed;
        EasyDccThrottle easyDccThrottle = this;
        synchronized (easyDccThrottle) {
            oldSpeed = this.speedSetting;
            this.speedSetting = speed;
        }
        if (this.speedStepMode == SpeedStepMode.NMRA_DCC_128) {
            value = (int)(126.0f * speed);
            if (value > 0) {
                ++value;
            }
            if (value > 127) {
                value = 127;
            }
            if (value < 0) {
                value = 1;
            }
            result = NmraPacket.speedStep128Packet(this.address.getNumber(), this.address.isLongAddress(), value, this.isForward);
        } else {
            value = (int)(28.0f * speed);
            if (value > 0) {
                ++value;
            }
            if (value > 28) {
                value = 28;
            }
            if (value < 0) {
                value = 1;
            }
            result = NmraPacket.speedStep28Packet(this.address.getNumber(), this.address.isLongAddress(), value, this.isForward);
        }
        EasyDccMessage m = new EasyDccMessage(1 + 3 * result.length);
        int i = 0;
        m.setElement(i++, 81);
        for (int j = 0; j < result.length; ++j) {
            m.setElement(i++, 32);
            m.addIntAsTwoHex(result[j] & 0xFF, i);
            i += 2;
        }
        this.tc.sendEasyDccMessage(m, null);
        EasyDccThrottle easyDccThrottle2 = this;
        synchronized (easyDccThrottle2) {
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        }
        this.record(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        EasyDccThrottle easyDccThrottle = this;
        synchronized (easyDccThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    public void throttleDispose() {
        this.active = false;
        this.finishRecord();
    }
}

