/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import jmri.SensorManager;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.easydcc.EasyDccInterface;
import jmri.jmrix.easydcc.EasyDccListener;
import jmri.jmrix.easydcc.EasyDccMessage;
import jmri.jmrix.easydcc.EasyDccReply;
import jmri.jmrix.easydcc.EasyDccSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyDccTrafficController
extends AbstractMRTrafficController
implements EasyDccInterface {
    EasyDccSystemConnectionMemo mMemo = null;
    private static final Logger log = LoggerFactory.getLogger(EasyDccTrafficController.class);

    public EasyDccTrafficController(EasyDccSystemConnectionMemo adaptermemo) {
        this.mMemo = adaptermemo;
        log.debug("creating a new EasyDccTrafficController object");
    }

    @Override
    public synchronized void addEasyDccListener(EasyDccListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeEasyDccListener(EasyDccListener l) {
        this.removeListener(l);
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((EasyDccListener)client).message((EasyDccMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply m) {
        ((EasyDccListener)client).reply((EasyDccReply)m);
    }

    public void setSensorManager(SensorManager m) {
    }

    @Override
    protected AbstractMRMessage pollMessage() {
        return null;
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return null;
    }

    @Override
    public void sendEasyDccMessage(EasyDccMessage m, EasyDccListener reply) {
        if (m == null) {
            log.debug("empty message");
            return;
        }
        log.debug("EasyDccTrafficController sendMessage() {}", (Object)m.toString());
        this.sendMessage(m, reply);
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        return EasyDccMessage.getProgMode();
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return EasyDccMessage.getExitProgMode();
    }

    public EasyDccSystemConnectionMemo getSystemConnectionMemo() {
        return this.mMemo;
    }

    public void setSystemConnectionMemo(EasyDccSystemConnectionMemo m) {
        this.mMemo = m;
    }

    @Override
    protected AbstractMRReply newReply() {
        return new EasyDccReply();
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        if ((msg.getElement(0) == 67 && msg.getElement(1) == 86 || msg.getElement(0) == 86) && msg.getNumDataElements() > 4 && msg.getElement(msg.getNumDataElements() - 2) != 80) {
            return false;
        }
        int index = msg.getNumDataElements() - 1;
        return msg.getElement(index) == 13;
    }

    @Override
    protected void terminate() {
        if (this.mCurrentMode == 1) {
            log.debug("skipping sending normal mode during termination");
            return;
        }
        super.terminate();
    }
}

