/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import java.util.EnumSet;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.ecos.EcosDccThrottle;
import jmri.jmrix.ecos.EcosListener;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosReply;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosDccThrottleManager
extends AbstractThrottleManager
implements EcosListener {
    private static final Logger log = LoggerFactory.getLogger(EcosDccThrottleManager.class);

    public EcosDccThrottleManager(EcosSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public void reply(EcosReply m) {
    }

    @Override
    public void message(EcosMessage m) {
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        if (address instanceof DccLocoAddress) {
            log.debug("new EcosDccThrottle for {}", (Object)address);
            new EcosDccThrottle((DccLocoAddress)address, (EcosSystemConnectionMemo)this.adapterMemo, control);
        } else {
            log.error("{} is not an DccLocoAddress", (Object)address);
            this.failedThrottleRequest(address, "LocoAddress " + address + " is not a DccLocoAddress");
        }
    }

    @Override
    public boolean hasDispatchFunction() {
        return false;
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return EcosDccThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return !EcosDccThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean addressTypeUnique() {
        return false;
    }

    @Override
    public String[] getAddressTypes() {
        return new String[]{LocoAddress.Protocol.DCC.getPeopleName(), LocoAddress.Protocol.MFX.getPeopleName(), LocoAddress.Protocol.MOTOROLA.getPeopleName(), LocoAddress.Protocol.SELECTRIX.getPeopleName(), LocoAddress.Protocol.LGB.getPeopleName()};
    }

    @Override
    public LocoAddress.Protocol[] getAddressProtocolTypes() {
        return new LocoAddress.Protocol[]{LocoAddress.Protocol.DCC, LocoAddress.Protocol.MFX, LocoAddress.Protocol.MOTOROLA, LocoAddress.Protocol.SELECTRIX, LocoAddress.Protocol.LGB};
    }

    static boolean isLongAddress(int num) {
        return num >= 127;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128, SpeedStepMode.NMRA_DCC_28, SpeedStepMode.NMRA_DCC_14);
    }

    public void throttleSetup(EcosDccThrottle throttle, LocoAddress address, boolean result) {
        if (result) {
            log.debug("Ecos Throttle has control over loco {}", (Object)address);
            this.notifyThrottleKnown(throttle, address);
        } else {
            log.debug("Ecos Throttle has NO control over loco {}", (Object)address);
            this.failedThrottleRequest(address, "Loco is alredy in use by anoher throttle " + address);
        }
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        if (super.disposeThrottle(t, l)) {
            if (t instanceof EcosDccThrottle) {
                EcosDccThrottle lnt = (EcosDccThrottle)t;
                lnt.throttleDispose();
                return true;
            }
            log.error("{} is not an EcosDccThrottle", (Object)t);
        }
        return false;
    }
}

