/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import java.util.HashMap;
import java.util.List;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.beans.Bean;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrix.ecos.Bundle;
import jmri.jmrix.ecos.EcosReply;

public class EcosLocoAddress
extends Bean
implements LocoAddress {
    private String _ecosObject = null;
    private int _dccAddress = 0;
    private String _ecosDescription = null;
    private String _rosterId = null;
    private String _ecosProtocolString = null;
    private LocoAddress.Protocol _protocol = LocoAddress.Protocol.DCC;
    private SpeedStepMode _speedSteps = SpeedStepMode.NMRA_DCC_128;
    boolean direction;
    int currentSpeed;
    private boolean doNotAddToRoster = false;
    public static int MFX_DCCAddressOffset = 20000;
    HashMap<Integer, Integer> cvValues = new HashMap();
    boolean _tempEntry = false;

    public EcosLocoAddress(int dCCAddress) {
        this._dccAddress = dCCAddress;
    }

    public EcosLocoAddress(String ecosObject, String rosterAtt) {
        this._ecosObject = ecosObject;
        List<RosterEntry> l = Roster.getDefault().getEntriesWithAttributeKeyValue(rosterAtt, ecosObject);
        if (l.size() > 0) {
            this._rosterId = l.get(0).getId();
        }
    }

    public void setCV(int cv, int value) {
        this.cvValues.put(cv, value);
    }

    public int getCV(int cv) {
        if (this.cvValues.containsKey(cv)) {
            return this.cvValues.get(cv);
        }
        return -1;
    }

    public String getCVAsString(int cv) {
        int val = this.getCV(cv);
        if (val == -1) {
            return null;
        }
        return "" + val;
    }

    public void setLocoAddress(int dCCAddress) {
        this._dccAddress = dCCAddress;
    }

    @Override
    public int getNumber() {
        return this._dccAddress;
    }

    public String getEcosObject() {
        return this._ecosObject;
    }

    public int getEcosObjectAsInt() {
        return Integer.parseInt(this._ecosObject);
    }

    public void doNotAddToRoster() {
        this.doNotAddToRoster = true;
    }

    public void allowAddToRoster() {
        this.doNotAddToRoster = false;
    }

    public boolean addToRoster() {
        return !this.doNotAddToRoster;
    }

    protected void setSpeed(int speed) {
        int oldspeed = this.currentSpeed;
        this.currentSpeed = speed;
        this.firePropertyChange("Speed", oldspeed, this.currentSpeed);
    }

    public int getSpeed() {
        return this.currentSpeed;
    }

    protected void setDirection(String line) {
        this.setDirection(this.getDirection(line));
    }

    protected void setDirection(boolean dir) {
        boolean olddir = this.direction;
        this.direction = dir;
        this.firePropertyChange("Direction", olddir, this.direction);
    }

    public boolean getDirection() {
        return this.direction;
    }

    public String getDirectionAsString() {
        if (this.direction) {
            return Bundle.getMessage("Forward");
        }
        return Bundle.getMessage("Reverse");
    }

    public void setEcosObject(String ecosObject) {
        this._ecosObject = ecosObject;
    }

    public String getEcosDescription() {
        return this._ecosDescription;
    }

    public void setEcosDescription(String description) {
        if (description.startsWith("\"")) {
            description = description.substring(1, description.length());
        }
        if (description.endsWith("\"")) {
            description = description.substring(0, description.length() - 1);
        }
        String oldValue = this._ecosDescription;
        this._ecosDescription = description;
        this.firePropertyChange("name", oldValue, this._ecosDescription);
    }

    public String getRosterId() {
        return this._rosterId;
    }

    public void setRosterId(String roster) {
        String oldValue = this._rosterId;
        this._rosterId = roster;
        this.firePropertyChange("RosterId", oldValue, this._rosterId);
    }

    public String getECOSProtocol() {
        return this._ecosProtocolString;
    }

    public SpeedStepMode getSpeedStepMode() {
        return this._speedSteps;
    }

    public void setProtocol(String protocol) {
        String oldValue = this._ecosProtocolString;
        this._ecosProtocolString = protocol;
        this.firePropertyChange("protocol", oldValue, this._ecosProtocolString);
        if (protocol.startsWith("DCC")) {
            this._protocol = LocoAddress.Protocol.DCC;
        } else if (protocol.startsWith("MM")) {
            this._protocol = LocoAddress.Protocol.MOTOROLA;
        } else if (protocol.startsWith("SX")) {
            this._protocol = LocoAddress.Protocol.SELECTRIX;
        } else if (protocol.startsWith("LBG")) {
            this._protocol = LocoAddress.Protocol.SELECTRIX;
        }
        if (protocol.endsWith("128")) {
            this._speedSteps = SpeedStepMode.NMRA_DCC_128;
        } else if (protocol.endsWith("28")) {
            this._speedSteps = SpeedStepMode.NMRA_DCC_28;
        } else if (protocol.endsWith("27")) {
            this._speedSteps = SpeedStepMode.NMRA_DCC_27;
        } else if (protocol.endsWith("14")) {
            this._speedSteps = SpeedStepMode.NMRA_DCC_14;
        }
    }

    @Override
    public LocoAddress.Protocol getProtocol() {
        return this._protocol;
    }

    public void setEcosTempEntry(boolean boo) {
        this._tempEntry = boo;
    }

    public boolean getEcosTempEntry() {
        return this._tempEntry;
    }

    public void reply(EcosReply m) {
        String msg = m.toString();
        if (m.getResultCode() != 0) {
            return;
        }
        if (msg.startsWith("<REPLY get(" + this._ecosObject + ",") || msg.startsWith("<EVENT " + this._ecosObject + ">")) {
            if (msg.contains("speed")) {
                this.setSpeed(Integer.parseInt(EcosReply.getContentDetails(msg, "speed")));
            }
            if (msg.contains("dir")) {
                this.setDirection(this.getDirection(msg));
            }
            if (msg.contains("protocol")) {
                this.setProtocol(EcosReply.getContentDetails(msg, "protocol"));
            }
            if (msg.contains("name")) {
                String name = EcosReply.getContentDetails(msg, "name").trim();
                this.setEcosDescription(name);
            }
        }
    }

    boolean getDirection(String line) {
        boolean newDirection = false;
        if (EcosReply.getContentDetails(line, "dir").equals("0")) {
            newDirection = true;
        }
        return newDirection;
    }

    public void dispose() {
    }
}

