/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.ConfigureManager;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.ShutDownManager;
import jmri.ShutDownTask;
import jmri.implementation.AbstractShutDownTask;
import jmri.jmrit.beantable.ListedTableFrame;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterConfigManager;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrix.ecos.Bundle;
import jmri.jmrix.ecos.EcosListener;
import jmri.jmrix.ecos.EcosLocoAddress;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosPreferences;
import jmri.jmrix.ecos.EcosReply;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.EcosTrafficController;
import jmri.jmrix.ecos.utilities.EcosLocoToRoster;
import jmri.jmrix.ecos.utilities.GetEcosObjectNumber;
import jmri.jmrix.ecos.utilities.RemoveObjectFromEcos;
import jmri.jmrix.ecos.utilities.RosterToEcos;
import jmri.managers.AbstractManager;
import jmri.profile.ProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosLocoAddressManager
extends AbstractManager<NamedBean>
implements EcosListener {
    private boolean addLocoToRoster = false;
    ShutDownTask ecosLocoShutDownTask;
    private EcosLocoToRoster locoToRoster;
    private boolean monitorState = false;
    private boolean processLocoToRosterQueue = true;
    private EcosPreferences p;
    private RosterConfigManager rcm;
    private RosterEntry _re;
    private String rosterAttribute;
    private EcosTrafficController tc;
    private Thread waitPrefLoad;
    private Hashtable<String, EcosLocoAddress> _tecos = new Hashtable();
    private Hashtable<Integer, EcosLocoAddress> _tdcc = new Hashtable();
    private static final Logger log = LoggerFactory.getLogger(EcosLocoAddressManager.class);

    public EcosLocoAddressManager(@Nonnull EcosSystemConnectionMemo memo) {
        super(memo);
        this.init();
    }

    private void init() {
        this.locoToRoster = new EcosLocoToRoster(this.getMemo());
        this.tc = this.getMemo().getTrafficController();
        this.p = this.getMemo().getPreferenceManager();
        this.rosterAttribute = this.p.getRosterAttribute();
        this.rcm = InstanceManager.getDefault(RosterConfigManager.class);
        this.loadEcosData();
        try {
            if (InstanceManager.getNullableDefault(ListedTableFrame.class) == null) {
                new ListedTableFrame();
            }
            InstanceManager.getDefault(ListedTableFrame.class).addTable("jmri.jmrix.ecos.swing.locodatabase.EcosLocoTableTabAction", "ECoS Loco Database", false);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
    }

    @Override
    @Nonnull
    public EcosSystemConnectionMemo getMemo() {
        return (EcosSystemConnectionMemo)this.memo;
    }

    @Override
    public char typeLetter() {
        return 'Z';
    }

    @Override
    public Class<NamedBean> getNamedBeanClass() {
        return NamedBean.class;
    }

    @Override
    public int getXMLOrder() {
        return 65400;
    }

    @Override
    @Nonnull
    public String makeSystemName(@Nonnull String s) {
        return s;
    }

    public void clearLocoToRoster() {
        this.addLocoToRoster = false;
    }

    public void setLocoToRoster() {
        this.addLocoToRoster = true;
    }

    public boolean getLocoToRoster() {
        return this.addLocoToRoster;
    }

    public EcosLocoAddress provideEcosLoco(String EcosObject, int DCCAddress) {
        EcosLocoAddress l = this.getByEcosObject(EcosObject);
        if (l != null) {
            return l;
        }
        l = new EcosLocoAddress(DCCAddress);
        l.setEcosObject(EcosObject);
        this.register(l);
        return l;
    }

    public EcosLocoAddress provideByDccAddress(int dccAddress) {
        EcosLocoAddress l = this.getByDccAddress(dccAddress);
        if (l != null) {
            return l;
        }
        l = new EcosLocoAddress(dccAddress);
        this.register(l);
        return this._tdcc.get(dccAddress);
    }

    public EcosLocoAddress provideByEcosObject(String ecosObject) {
        EcosLocoAddress l = this.getByEcosObject(ecosObject);
        if (l != null) {
            return l;
        }
        l = new EcosLocoAddress(ecosObject, this.p.getRosterAttribute());
        this.register(l);
        EcosMessage m = new EcosMessage("request(" + ecosObject + ", view)");
        this.tc.sendEcosMessage(m, this);
        m = new EcosMessage("get(" + ecosObject + ", speed)");
        this.tc.sendEcosMessage(m, this);
        m = new EcosMessage("get(" + ecosObject + ", dir)");
        this.tc.sendEcosMessage(m, this);
        return this._tecos.get(ecosObject);
    }

    public EcosLocoAddress getByEcosObject(String ecosObject) {
        return this._tecos.get(ecosObject);
    }

    public EcosLocoAddress getByDccAddress(int dccAddress) {
        return this._tdcc.get(dccAddress);
    }

    public String[] getEcosObjectArray() {
        Object[] arr = new String[this._tecos.size()];
        Enumeration<String> en = this._tecos.keys();
        int i = 0;
        while (en.hasMoreElements()) {
            arr[i] = en.nextElement();
            ++i;
        }
        Arrays.sort(arr);
        return arr;
    }

    public List<String> getEcosObjectList() {
        Object[] arr = new String[this._tecos.size()];
        ArrayList<String> out = new ArrayList<String>();
        Enumeration<String> en = this._tecos.keys();
        int i = 0;
        while (en.hasMoreElements()) {
            arr[i] = en.nextElement();
            ++i;
        }
        Arrays.sort(arr);
        for (i = 0; i < arr.length; ++i) {
            out.add((String)arr[i]);
        }
        return out;
    }

    private void loadEcosData() {
        if (this.p.getPreferencesLoaded() && this.rcm.isInitialized(ProfileManager.getDefault().getActiveProfile())) {
            this.loadData();
        } else {
            if (this.waitPrefLoad != null) {
                this.waitPrefLoad.interrupt();
                this.waitPrefLoad = null;
            }
            this.waitPrefLoad = new Thread(new WaitPrefLoad());
            this.waitPrefLoad.setName("Wait for Preferences to be loaded");
            this.waitPrefLoad.start();
        }
    }

    private void loadData() {
        this.tc.addEcosListener(this);
        try {
            Roster.getDefault().addPropertyChangeListener(this);
            EcosMessage m = new EcosMessage("request(10, view)");
            this.tc.sendWaitMessage(m, this);
            m = new EcosMessage("queryObjects(10, addr, name, protocol)");
            this.tc.sendEcosMessage(m, this);
            if (this.ecosLocoShutDownTask == null) {
                this.ecosLocoShutDownTask = new AbstractShutDownTask("Ecos Loco Database Shutdown"){

                    @Override
                    public Boolean call() {
                        return EcosLocoAddressManager.this.shutdownDispose();
                    }

                    @Override
                    public void run() {
                        EcosLocoAddressManager.this.disposefinal();
                    }
                };
            }
            InstanceManager.getDefault(ShutDownManager.class).register(this.ecosLocoShutDownTask);
        }
        catch (NullPointerException npe) {
            log.debug("Delayed initialization of EcosLocoAddressManager failed, no roster information available");
        }
    }

    public void monitorLocos(boolean monitor) {
        this.monitorState = monitor;
        List<String> objects = this.getEcosObjectList();
        for (String ecosObject : objects) {
            EcosMessage m = new EcosMessage("get(" + ecosObject + ", speed)");
            this.tc.sendEcosMessage(m, this);
            m = new EcosMessage("get(" + ecosObject + ", dir)");
            this.tc.sendEcosMessage(m, this);
        }
    }

    public void deleteEcosLoco(EcosLocoAddress s) {
        this.deregister(s);
    }

    @Override
    public void register(EcosLocoAddress s) {
        int oldsize;
        String ecosObject = s.getEcosObject();
        if (ecosObject != null) {
            oldsize = this._tecos.size();
            this._tecos.put(ecosObject, s);
            this.firePropertyChange("length", oldsize, this._tecos.size());
        }
        oldsize = this._tdcc.size();
        int dccAddress = s.getNumber();
        this._tdcc.put(dccAddress, s);
        this.firePropertyChange("length", oldsize, this._tdcc.size());
        s.addPropertyChangeListener(this);
    }

    @Override
    public void deregister(EcosLocoAddress s) {
        s.removePropertyChangeListener(this);
        String ecosObject = s.getEcosObject();
        int oldsize = this._tecos.size();
        this._tecos.remove(ecosObject);
        this.firePropertyChange("length", (Object)oldsize, (Object)this._tecos.size());
        int dccAddress = s.getNumber();
        oldsize = this._tdcc.size();
        this._tdcc.remove(dccAddress);
        this.firePropertyChange("length", (Object)oldsize, (Object)this._tdcc.size());
        EcosMessage m = new EcosMessage("release(" + ecosObject + ", view)");
        this.tc.sendEcosMessage(m, this);
    }

    private boolean disposefinal() {
        if (InstanceManager.getNullableDefault(ConfigureManager.class) != null) {
            InstanceManager.getDefault(ConfigureManager.class).deregister(this);
        }
        this._tecos.clear();
        this._tdcc.clear();
        return true;
    }

    @Override
    public void dispose() {
    }

    public void terminateThreads() {
        if (this.waitPrefLoad != null) {
            this.waitPrefLoad.interrupt();
        }
    }

    protected boolean threadsRunning() {
        return this.waitPrefLoad != null ? this.waitPrefLoad.isAlive() : false;
    }

    public boolean shutdownDispose() {
        boolean hasTempEntries = false;
        Enumeration<String> en = this._tecos.keys();
        this._tdcc.clear();
        while (en.hasMoreElements()) {
            String ecosObject = en.nextElement();
            if (this._tecos.get(ecosObject).getEcosTempEntry()) {
                hasTempEntries = true;
                continue;
            }
            this.deregister(this.getByEcosObject(ecosObject));
            this._tecos.remove(ecosObject);
        }
        if (this.p.getAdhocLocoFromEcos() == 1) {
            this.disposefinal();
        } else if (!hasTempEntries) {
            this.disposefinal();
        } else if (this.p.getAdhocLocoFromEcos() == 0) {
            final JDialog dialog = new JDialog();
            dialog.setTitle(Bundle.getMessage("RemoveLocoTitle"));
            dialog.setLocation(300, 200);
            dialog.setDefaultCloseOperation(2);
            JPanel container = new JPanel();
            container.setLayout(new BoxLayout(container, 1));
            container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JLabel question = new JLabel(Bundle.getMessage("RemoveLocoLine1"));
            question.setAlignmentX(0.5f);
            container.add(question);
            question = new JLabel(Bundle.getMessage("RemoveLocoLine2"));
            question.setAlignmentX(0.5f);
            container.add(question);
            final JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
            remember.setFont(remember.getFont().deriveFont(10.0f));
            remember.setAlignmentX(0.5f);
            remember.setVisible(true);
            JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
            JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
            JPanel button = new JPanel();
            button.setAlignmentX(0.5f);
            button.add(yesButton);
            button.add(noButton);
            container.add(button);
            noButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (remember.isSelected()) {
                        EcosLocoAddressManager.this.p.setAdhocLocoFromEcos(1);
                    }
                    dialog.dispose();
                }
            });
            yesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (remember.isSelected()) {
                        EcosLocoAddressManager.this.p.setAdhocLocoFromEcos(2);
                    }
                    dialog.dispose();
                }
            });
            container.add(remember);
            container.setAlignmentX(0.5f);
            container.setAlignmentY(0.5f);
            dialog.getContentPane().add(container);
            dialog.pack();
            dialog.setModal(true);
            dialog.setVisible(true);
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.getLocoToRoster()) {
            return;
        }
        if (e.getPropertyName().equals("add")) {
            this._re = (RosterEntry)e.getNewValue();
        } else if (e.getPropertyName().equals("saved")) {
            if (this._re != null) {
                if (this._re.getAttribute(this.rosterAttribute) != null) {
                    this._re = null;
                    return;
                }
                if (this.p.getAddLocoToEcos() == 0) {
                    final JDialog dialog = new JDialog();
                    dialog.setTitle(Bundle.getMessage("AddLocoTitle"));
                    dialog.setLocation(300, 200);
                    dialog.setDefaultCloseOperation(2);
                    JPanel container = new JPanel();
                    container.setLayout(new BoxLayout(container, 1));
                    container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    JLabel question = new JLabel(Bundle.getMessage("AddLocoXQuestion", this._re.getId(), this.getMemo().getUserName()));
                    question.setAlignmentX(0.5f);
                    container.add(question);
                    final JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
                    remember.setFont(remember.getFont().deriveFont(10.0f));
                    remember.setAlignmentX(0.5f);
                    remember.setVisible(true);
                    JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
                    JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
                    JPanel button = new JPanel();
                    button.setAlignmentX(0.5f);
                    button.add(yesButton);
                    button.add(noButton);
                    container.add(button);
                    noButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (remember.isSelected()) {
                                EcosLocoAddressManager.this.p.setAddLocoToEcos(1);
                            }
                            EcosLocoAddressManager.this._re = null;
                            dialog.dispose();
                        }
                    });
                    yesButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (remember.isSelected()) {
                                EcosLocoAddressManager.this.p.setAddLocoToEcos(2);
                            }
                            RosterToEcos rosterToEcos = new RosterToEcos(EcosLocoAddressManager.this.getMemo());
                            rosterToEcos.createEcosLoco(EcosLocoAddressManager.this._re);
                            EcosLocoAddressManager.this._re = null;
                            dialog.dispose();
                        }
                    });
                    container.add(remember);
                    container.setAlignmentX(0.5f);
                    container.setAlignmentY(0.5f);
                    dialog.getContentPane().add(container);
                    dialog.pack();
                    dialog.setModal(true);
                    dialog.setVisible(true);
                }
                if (this.p.getAddLocoToEcos() == 2) {
                    RosterToEcos rosterToEcos = new RosterToEcos(this.getMemo());
                    rosterToEcos.createEcosLoco(this._re);
                    this._re = null;
                }
            }
        } else if (e.getPropertyName().equals("remove")) {
            this._re = (RosterEntry)e.getNewValue();
            if (this._re.getAttribute(this.rosterAttribute) != null) {
                if (this.p.getRemoveLocoFromEcos() == 2) {
                    RemoveObjectFromEcos removeObjectFromEcos = new RemoveObjectFromEcos();
                    removeObjectFromEcos.removeObjectFromEcos(this._re.getAttribute(this.p.getRosterAttribute()), this.tc);
                    this.deleteEcosLoco(this.provideByEcosObject(this._re.getAttribute(this.p.getRosterAttribute())));
                } else if (this.p.getRemoveLocoFromEcos() == 0) {
                    final JDialog dialog = new JDialog();
                    dialog.setTitle(Bundle.getMessage("RemoveLocoTitle"));
                    dialog.setLocation(300, 200);
                    dialog.setDefaultCloseOperation(2);
                    JPanel container = new JPanel();
                    container.setLayout(new BoxLayout(container, 1));
                    container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    JLabel question = new JLabel(Bundle.getMessage("RemoveLocoXQuestion", this.getMemo().getUserName()));
                    question.setAlignmentX(0.5f);
                    container.add(question);
                    final JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
                    remember.setFont(remember.getFont().deriveFont(10.0f));
                    remember.setAlignmentX(0.5f);
                    remember.setVisible(true);
                    JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
                    JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
                    JPanel button = new JPanel();
                    button.setAlignmentX(0.5f);
                    button.add(yesButton);
                    button.add(noButton);
                    container.add(button);
                    noButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (remember.isSelected()) {
                                EcosLocoAddressManager.this.p.setRemoveLocoFromEcos(1);
                            }
                            EcosLocoAddressManager.this.provideByEcosObject(EcosLocoAddressManager.this._re.getAttribute(EcosLocoAddressManager.this.p.getRosterAttribute())).setRosterId(null);
                            dialog.dispose();
                        }
                    });
                    yesButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (remember.isSelected()) {
                                EcosLocoAddressManager.this.p.setRemoveLocoFromEcos(2);
                            }
                            RemoveObjectFromEcos removeObjectFromEcos = new RemoveObjectFromEcos();
                            removeObjectFromEcos.removeObjectFromEcos(EcosLocoAddressManager.this._re.getAttribute(EcosLocoAddressManager.this.p.getRosterAttribute()), EcosLocoAddressManager.this.tc);
                            EcosLocoAddressManager.this.deleteEcosLoco(EcosLocoAddressManager.this.provideByEcosObject(EcosLocoAddressManager.this._re.getAttribute(EcosLocoAddressManager.this.p.getRosterAttribute())));
                            dialog.dispose();
                        }
                    });
                    container.add(remember);
                    container.setAlignmentX(0.5f);
                    container.setAlignmentY(0.5f);
                    dialog.getContentPane().add(container);
                    dialog.pack();
                    dialog.setModal(true);
                    dialog.setVisible(true);
                }
            }
            this._re = null;
        } else if (e.getPropertyName().equals("throttleAssigned")) {
            DccLocoAddress la = (DccLocoAddress)e.getNewValue();
            EcosLocoAddress ela = this.getByDccAddress(la.getNumber());
            EcosMessage m = new EcosMessage("get(" + ela.getEcosObject() + ", speed)");
            this.tc.sendEcosMessage(m, this);
            m = new EcosMessage("get(" + ela.getEcosObject() + ", dir)");
            this.tc.sendEcosMessage(m, this);
        }
    }

    @Override
    public void reply(EcosReply m) {
        block10: {
            String[] msgDetails;
            List<String> headerDetails;
            int ecosObjectId;
            block11: {
                block12: {
                    block13: {
                        if (m.getResultCode() != 0) break block10;
                        ecosObjectId = m.getEcosObjectId();
                        if (ecosObjectId != 10 && (ecosObjectId < 1000 || ecosObjectId > 2000)) {
                            log.debug("message received that is not within the valid loco object range");
                            return;
                        }
                        headerDetails = m.getReplyHeaderDetails();
                        msgDetails = m.getContents();
                        if (!m.isUnsolicited()) break block11;
                        if (ecosObjectId != 10) break block12;
                        log.debug("We have received notification of a change in the Loco list");
                        if (msgDetails.length != 0) break block13;
                        EcosMessage mout = new EcosMessage("queryObjects(10)");
                        this.tc.sendEcosMessage(mout, this);
                        mout = new EcosMessage("release(10, view)");
                        this.tc.sendEcosMessage(mout, this);
                        mout = new EcosMessage("request(10, view)");
                        this.tc.sendEcosMessage(mout, this);
                        break block10;
                    }
                    if (!msgDetails[0].contains("msg[LIST_CHANGED]")) break block10;
                    EcosMessage mout = new EcosMessage("queryObjects(10)");
                    this.tc.sendEcosMessage(mout, this);
                    break block10;
                }
                log.debug("Forwarding on State change for {}", (Object)ecosObjectId);
                String strLocoObject = Integer.toString(ecosObjectId);
                EcosLocoAddress tmploco = this._tecos.get(strLocoObject);
                if (tmploco == null) break block10;
                tmploco.reply(m);
                break block10;
            }
            String replyType = m.getReplyType();
            if (replyType.equals("queryObjects")) {
                if (ecosObjectId == 10) {
                    if (headerDetails.size() == 0 || headerDetails.size() == 1 && headerDetails.get(0).equals("")) {
                        this.checkLocoList(msgDetails);
                    } else {
                        this.processLocoToRosterQueue = false;
                        for (String line : msgDetails) {
                            String[] objectdetail = line.split(" ");
                            EcosLocoAddress tmploco = null;
                            String strde = objectdetail[0];
                            int object = Integer.parseInt(strde = strde.trim());
                            if (1000 <= object && object < 2000) {
                                tmploco = this.provideByEcosObject(strde);
                            }
                            this.decodeLocoDetails(tmploco, line, true);
                        }
                        this.locoToRoster.processQueue();
                        this.processLocoToRosterQueue = true;
                    }
                }
            } else if (replyType.equals("get")) {
                EcosLocoAddress tmploco = this.provideByEcosObject(Integer.toString(ecosObjectId));
                for (String line : msgDetails) {
                    this.decodeLocoDetails(tmploco, line, false);
                }
            }
        }
    }

    void decodeLocoDetails(EcosLocoAddress tmploco, String line, boolean addToRoster) {
        if (tmploco == null) {
            return;
        }
        if (line.contains("cv")) {
            String cv = EcosReply.getContentDetails(line, "cv");
            cv = cv.replaceAll("\\s", "");
            int cvnum = Integer.parseInt(cv.substring(0, cv.indexOf(",")));
            int cvval = Integer.parseInt(cv.substring(cv.indexOf(",") + 1, cv.length()));
            tmploco.setCV(cvnum, cvval);
            if (cvnum == 8 && this.processLocoToRosterQueue) {
                this.locoToRoster.processQueue();
            }
        }
        if (line.contains("addr")) {
            tmploco.setLocoAddress(GetEcosObjectNumber.getEcosObjectNumber(line, "addr[", "]"));
            if (tmploco.getCV(7) == -1) {
                tmploco.setCV(7, 0);
                this.getEcosCVs(tmploco);
            }
        }
        if (line.contains("name")) {
            String name = EcosReply.getContentDetails(line, "name").trim();
            name = name.substring(1, name.length() - 1);
            tmploco.setEcosDescription(name);
        }
        if (line.contains("protocol")) {
            tmploco.setProtocol(EcosReply.getContentDetails(line, "protocol"));
        }
        if (line.contains("speed")) {
            tmploco.setSpeed(Integer.parseInt(EcosReply.getContentDetails(line, "speed")));
        }
        if (line.contains("dir")) {
            boolean newDirection = false;
            if (EcosReply.getContentDetails(line, "dir").equals("0")) {
                newDirection = true;
            }
            tmploco.setDirection(newDirection);
        }
        this.register(tmploco);
        if (this.p.getAddLocoToJMRI() != 1 && addToRoster) {
            this.locoToRoster.addToQueue(tmploco);
        }
    }

    void checkLocoList(String[] ecoslines) {
        String loco;
        log.debug("Checking loco list");
        String[] stringArray = ecoslines;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String ecosline;
            loco = ecosline = stringArray[i];
            if (this.getByEcosObject(loco = loco.replaceAll("[\\n\\r]", "")) != null) continue;
            log.debug("We are to add loco {} to the Ecos Loco List", (Object)loco);
            EcosMessage mout = new EcosMessage("get(" + loco + ", addr, name, protocol)");
            this.tc.sendEcosMessage(mout, this);
        }
        String[] jmrilist = this.getEcosObjectArray();
        boolean nomatch = true;
        for (String entry : jmrilist) {
            nomatch = true;
            String[] stringArray2 = ecoslines;
            int n2 = stringArray2.length;
            for (int i = 0; i < n2; ++i) {
                String ecosline;
                loco = ecosline = stringArray2[i];
                if (!(loco = loco.replaceAll("[\\n\\r]", "")).equals(entry)) continue;
                nomatch = false;
                break;
            }
            if (!nomatch) continue;
            log.debug("Loco not found so need to remove from register");
            if (this.getByEcosObject(entry).getRosterId() != null) {
                String rosterid = this.getByEcosObject(entry).getRosterId();
                final Roster _roster = Roster.getDefault();
                final RosterEntry re = _roster.entryFromTitle(rosterid);
                re.deleteAttribute(this.p.getRosterAttribute());
                re.writeFile(null, null);
                Roster.getDefault().writeRoster();
                if (this.p.getRemoveLocoFromJMRI() == 2) {
                    _roster.removeEntry(re);
                    Roster.getDefault().writeRoster();
                } else if (this.p.getRemoveLocoFromJMRI() == 0) {
                    try {
                        final JDialog dialog = new JDialog();
                        dialog.setTitle(Bundle.getMessage("RemoveRosterEntryTitle"));
                        dialog.setLocation(300, 200);
                        dialog.setDefaultCloseOperation(2);
                        JPanel container = new JPanel();
                        container.setLayout(new BoxLayout(container, 1));
                        container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                        JLabel question = new JLabel(Bundle.getMessage("RemoveRosterEntryX", rosterid));
                        question.setAlignmentX(0.5f);
                        container.add(question);
                        final JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
                        remember.setFont(remember.getFont().deriveFont(10.0f));
                        remember.setAlignmentX(0.5f);
                        remember.setVisible(true);
                        JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
                        JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
                        JPanel button = new JPanel();
                        button.setAlignmentX(0.5f);
                        button.add(yesButton);
                        button.add(noButton);
                        container.add(button);
                        noButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (remember.isSelected()) {
                                    EcosLocoAddressManager.this.p.setRemoveLocoFromJMRI(0);
                                }
                                dialog.dispose();
                            }
                        });
                        yesButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (remember.isSelected()) {
                                    EcosLocoAddressManager.this.p.setRemoveLocoFromJMRI(2);
                                }
                                EcosLocoAddressManager.this.setLocoToRoster();
                                _roster.removeEntry(re);
                                Roster.getDefault().writeRoster();
                                dialog.dispose();
                            }
                        });
                        container.add(remember);
                        container.setAlignmentX(0.5f);
                        container.setAlignmentY(0.5f);
                        dialog.getContentPane().add(container);
                        dialog.pack();
                        dialog.setModal(true);
                        dialog.setVisible(true);
                    }
                    catch (HeadlessException headlessException) {
                        // empty catch block
                    }
                }
            }
            this.deregister(this.getByEcosObject(entry));
        }
    }

    @Override
    public void message(EcosMessage m) {
    }

    private void getEcosCVs(EcosLocoAddress tmploco) {
        this.tc.addEcosListener(this);
        EcosMessage m = new EcosMessage("get(" + tmploco.getEcosObject() + ", cv[7])");
        this.tc.sendEcosMessage(m, this);
        m = new EcosMessage("get(" + tmploco.getEcosObject() + ", cv[8])");
        this.tc.sendEcosMessage(m, this);
    }

    public void refreshItems() {
        EcosMessage m = new EcosMessage("request(10, view)");
        this.tc.sendEcosMessage(m, this);
        if (this.monitorState) {
            int x;
            List<String> objects = this.getEcosObjectList();
            for (x = 0; x < objects.size(); ++x) {
                m = new EcosMessage("release(" + this.getByEcosObject(objects.get(x)) + ", view, control)");
                this.tc.sendEcosMessage(m, this);
            }
            for (x = 0; x < objects.size(); ++x) {
                m = new EcosMessage("request(" + this.getByEcosObject(objects.get(x)) + ", view)");
                this.tc.sendEcosMessage(m, this);
                m = new EcosMessage("get(" + this.getByEcosObject(objects.get(x)) + ", speed)");
                this.tc.sendEcosMessage(m, this);
                m = new EcosMessage("get(" + this.getByEcosObject(objects.get(x)) + ", dir)");
                this.tc.sendEcosMessage(m, this);
            }
        }
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage("EcosLocoAddresses");
    }

    private class WaitPrefLoad
    implements Runnable {
        boolean wait = false;
        int count = 0;

        private WaitPrefLoad() {
        }

        @Override
        public void run() {
            boolean result = true;
            log.debug("Waiting for the Ecos preferences to be loaded before loading the loco database on the Ecos");
            while (!this.wait) {
                result = this.waitForPrefLoad();
            }
            if (result) {
                EcosLocoAddressManager.this.loadData();
            } else {
                log.debug("waitForPrefLoad requested skip loadData()");
            }
        }

        private boolean waitForPrefLoad() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                log.trace("waitForPrefLoad received InterruptedException, honoring termination request");
                this.wait = true;
                return false;
            }
            boolean bl = this.wait = EcosLocoAddressManager.this.p.getPreferencesLoaded() && EcosLocoAddressManager.this.rcm.isInitialized(ProfileManager.getDefault().getActiveProfile());
            if (this.count >= 1000) {
                this.wait = true;
                log.warn("Timeout {} occurred on waiting for the Ecos preferences to be loaded", (Object)this.count);
                return false;
            }
            ++this.count;
            return true;
        }
    }
}

