/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.jmrix.ecos.Bundle;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.swing.preferences.PreferencesPane;
import jmri.swing.PreferencesPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosPreferences {
    private final EcosSystemConnectionMemo adaptermemo;
    boolean preferencesLoaded = false;
    Runnable ecosPreferencesShutDownTask = null;
    public static final int ASK = 0;
    public static final int NO = 1;
    public static final int YES = 2;
    private boolean _changeMade = false;
    private int _addlocotoecos = 0;
    private int _addlocotojmri = 0;
    private String _ecoslocodescription = null;
    private static final int NOSYNC = 0;
    private static final int WARN = 1;
    private static final int JMRI = 2;
    private static final int ECOS = 3;
    private int _locomaster = 0;
    private int _adhoclocofromecos = 0;
    private int _forcecontrolfromecos = 0;
    private boolean _locoControl = false;
    private int _removelocofromecos = 0;
    private int _removelocofromjmri = 0;
    private int _addturnoutstoecos = 0;
    private int _addturnoutstojmri = 0;
    private int _removeturnoutsfromjmri = 0;
    private int _removeturnoutsfromecos = 0;
    private String _rosterAttribute = "EcosObject";
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(EcosPreferences.class);

    public EcosPreferences(EcosSystemConnectionMemo memo) {
        log.debug("creating a new EcosPreferences object");
        this.ecosPreferencesShutDownTask = () -> InstanceManager.getDefault(ConfigureManager.class).storePrefs();
        InstanceManager.getDefault(ShutDownManager.class).register(this.ecosPreferencesShutDownTask);
        this.adaptermemo = memo;
        InstanceManager.store(new PreferencesPane(this), PreferencesPanel.class);
    }

    public boolean getPreferencesLoaded() {
        return this.preferencesLoaded;
    }

    public void setPreferencesLoaded() {
        this.preferencesLoaded = true;
        this.firePropertyChange("loaded", null, null);
    }

    public boolean getChangeMade() {
        return this._changeMade;
    }

    public void resetChangeMade() {
        this._changeMade = false;
    }

    public int getAddLocoToEcos() {
        return this._addlocotoecos;
    }

    public void setAddLocoToEcos(int boo) {
        this._addlocotoecos = boo;
        this.changeMade();
    }

    public int getAddLocoToJMRI() {
        return this._addlocotojmri;
    }

    public void setAddLocoToJMRI(int boo) {
        this._addlocotojmri = boo;
        this.changeMade();
    }

    public String getEcosLocoDescription() {
        return this._ecoslocodescription;
    }

    public void setEcosLocoDescription(String descript) {
        this._ecoslocodescription = descript;
        this.changeMade();
    }

    public int getLocoMaster() {
        return this._locomaster;
    }

    public void setLocoMaster(int master) {
        this._locomaster = master;
    }

    public void setLocoMaster(String master) {
        this._locomaster = master.equals(Bundle.getMessage("NOSYNC")) ? 0 : (master.equals(Bundle.getMessage("WARNING")) ? 1 : (master.equals("JMRI") ? 2 : (master.equals("ECoS") ? 3 : 0)));
        this.changeMade();
    }

    public String getLocoMasterAsString() {
        String result;
        switch (this._locomaster) {
            case 0: {
                result = Bundle.getMessage("NOSYNC");
                break;
            }
            case 1: {
                result = Bundle.getMessage("WARNING");
                break;
            }
            case 2: {
                result = "JMRI";
                break;
            }
            case 3: {
                result = "ECoS";
                break;
            }
            default: {
                result = Bundle.getMessage("NOSYNC");
            }
        }
        return result;
    }

    public int getAdhocLocoFromEcos() {
        return this._adhoclocofromecos;
    }

    public void setAdhocLocoFromEcos(int boo) {
        this._adhoclocofromecos = boo;
        this.changeMade();
    }

    public int getForceControlFromEcos() {
        return this._forcecontrolfromecos;
    }

    public void setForceControlFromEcos(int boo) {
        this._forcecontrolfromecos = boo;
        this.changeMade();
    }

    public boolean getLocoControl() {
        return this._locoControl;
    }

    public void setLocoControl(boolean boo) {
        this._locoControl = boo;
        this.changeMade();
    }

    public int getRemoveLocoFromEcos() {
        return this._removelocofromecos;
    }

    public void setRemoveLocoFromEcos(int boo) {
        this._removelocofromecos = boo;
        this.changeMade();
    }

    public int getRemoveLocoFromJMRI() {
        return this._removelocofromjmri;
    }

    public void setRemoveLocoFromJMRI(int boo) {
        this._removelocofromjmri = boo;
        this.changeMade();
    }

    public int getAddTurnoutsToEcos() {
        return this._addturnoutstoecos;
    }

    public void setAddTurnoutsToEcos(int boo) {
        this._addturnoutstoecos = boo;
        this.changeMade();
    }

    public int getAddTurnoutsToJMRI() {
        return this._addturnoutstojmri;
    }

    public void setAddTurnoutsToJMRI(int boo) {
        this._addturnoutstojmri = boo;
        this.changeMade();
    }

    public int getRemoveTurnoutsFromJMRI() {
        return this._removeturnoutsfromjmri;
    }

    public void setRemoveTurnoutsFromJMRI(int boo) {
        this._removeturnoutsfromjmri = boo;
        this.changeMade();
    }

    public int getRemoveTurnoutsFromEcos() {
        return this._removeturnoutsfromecos;
    }

    public void setRemoveTurnoutsFromEcos(int boo) {
        this._removeturnoutsfromecos = boo;
        this.changeMade();
    }

    public void setRosterAttribute(String att) {
        this._rosterAttribute = att == null || att.equals("") ? "EcosObject" : (att.startsWith("EcosObject") ? att : "EcosObject:" + att);
        this.changeMade();
    }

    public String getRosterAttribute() {
        return this._rosterAttribute;
    }

    public String getRosterAttributeSuffix() {
        try {
            return this._rosterAttribute.substring(11);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return null;
        }
    }

    public String name() {
        return null;
    }

    void changeMade() {
        this._changeMade = true;
        this.firePropertyChange("update", null, null);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }

    public EcosSystemConnectionMemo getAdaptermemo() {
        return this.adaptermemo;
    }
}

