/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jmri.DccLocoAddress;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.PhysicalLocationReporter;
import jmri.implementation.AbstractReporter;
import jmri.util.PhysicalLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosReporter
extends AbstractReporter
implements PhysicalLocationReporter {
    int lastLoco = -1;
    private int object;
    private int port;
    private static final Logger log = LoggerFactory.getLogger(EcosReporter.class);

    public EcosReporter(String systemName, String userName) {
        super(systemName, userName);
    }

    @Override
    public int getState() {
        return this.lastLoco;
    }

    @Override
    public void setState(int s) {
        this.lastLoco = s;
    }

    public int getObjectId() {
        return this.object;
    }

    public int getPort() {
        return this.port;
    }

    public void setObjectPort(int object, int port) {
        this.object = object;
        this.port = port;
    }

    public void decodeDetails(String msg) {
        int start = msg.indexOf(91) + 1;
        int end = msg.indexOf(93);
        String[] result = msg.substring(start, end).split(",");
        result[1] = result[1].trim();
        if (!result[1].equals("0000")) {
            IdTag idTag = InstanceManager.getDefault(IdTagManager.class).provideIdTag(result[1]);
            this.setReport(idTag);
        } else {
            this.setReport(null);
        }
    }

    @Override
    public LocoAddress getLocoAddress(String rep) {
        IdTag cr = (IdTag)this.getCurrentReport();
        IdTagManager tm = InstanceManager.getDefault(IdTagManager.class);
        Pattern p = Pattern.compile(tm.getSystemPrefix() + tm.typeLetter() + "(\\d+)");
        Matcher m = p.matcher(cr.getTagID());
        if (m.find()) {
            log.debug("Parsed address: {}", (Object)m.group(1));
            return new DccLocoAddress(Integer.parseInt(m.group(1)), LocoAddress.Protocol.DCC);
        }
        return null;
    }

    @Override
    public PhysicalLocationReporter.Direction getDirection(String rep) {
        return PhysicalLocationReporter.Direction.ENTER;
    }

    @Override
    public PhysicalLocation getPhysicalLocation() {
        return this.getPhysicalLocation(null);
    }

    @Override
    public PhysicalLocation getPhysicalLocation(String s) {
        return PhysicalLocation.getBeanPhysicalLocation(this);
    }
}

