/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import java.util.Comparator;
import java.util.ResourceBundle;
import jmri.AddressedProgrammerManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.Programmer;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.ShutDownManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.ecos.EcosDccThrottleManager;
import jmri.jmrix.ecos.EcosLocoAddressManager;
import jmri.jmrix.ecos.EcosPowerManager;
import jmri.jmrix.ecos.EcosPreferences;
import jmri.jmrix.ecos.EcosProgrammer;
import jmri.jmrix.ecos.EcosProgrammerManager;
import jmri.jmrix.ecos.EcosReporterManager;
import jmri.jmrix.ecos.EcosSensorManager;
import jmri.jmrix.ecos.EcosTrafficController;
import jmri.jmrix.ecos.EcosTurnoutManager;
import jmri.jmrix.ecos.swing.EcosComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;

public class EcosSystemConnectionMemo
extends DefaultSystemConnectionMemo {
    private ComponentFactory cf = null;
    private EcosTrafficController et;

    public EcosSystemConnectionMemo(EcosTrafficController et) {
        super("U", "ECoS");
        this.et = et;
        et.setAdapterMemo(this);
        this.init();
    }

    public EcosSystemConnectionMemo() {
        super("U", "ECoS");
        this.init();
    }

    private void init() {
        InstanceManager.store(this, EcosSystemConnectionMemo.class);
        this.cf = new EcosComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
        this.store(new EcosPreferences(this), EcosPreferences.class);
    }

    public EcosTrafficController getTrafficController() {
        return this.et;
    }

    public void setEcosTrafficController(EcosTrafficController et) {
        this.et = et;
        et.setAdapterMemo(this);
    }

    public void configureManagers() {
        EcosPowerManager powerManager = new EcosPowerManager(this.getTrafficController());
        InstanceManager.store(powerManager, PowerManager.class);
        this.store(powerManager, PowerManager.class);
        EcosLocoAddressManager locoManager = new EcosLocoAddressManager(this);
        this.store(locoManager, EcosLocoAddressManager.class);
        EcosDccThrottleManager throttleManager = new EcosDccThrottleManager(this);
        InstanceManager.setThrottleManager(throttleManager);
        this.store(throttleManager, ThrottleManager.class);
        EcosReporterManager reporterManager = new EcosReporterManager(this);
        InstanceManager.setReporterManager(reporterManager);
        this.store(reporterManager, ReporterManager.class);
        InstanceManager.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
        this.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
        InstanceManager.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
        this.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
        EcosSensorManager sensorManager = new EcosSensorManager(this);
        InstanceManager.setSensorManager(sensorManager);
        this.store(sensorManager, SensorManager.class);
        EcosTurnoutManager turnoutManager = new EcosTurnoutManager(this);
        InstanceManager.setTurnoutManager(turnoutManager);
        this.store(turnoutManager, TurnoutManager.class);
        this.register();
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.ecos.EcosActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    public EcosLocoAddressManager getLocoAddressManager() {
        return this.get(EcosLocoAddressManager.class);
    }

    public EcosTurnoutManager getTurnoutManager() {
        return (EcosTurnoutManager)this.get(TurnoutManager.class);
    }

    public EcosSensorManager getSensorManager() {
        return (EcosSensorManager)this.get(SensorManager.class);
    }

    public EcosPreferences getPreferenceManager() {
        return this.get(EcosPreferences.class);
    }

    public EcosDccThrottleManager getThrottleManager() {
        return (EcosDccThrottleManager)this.get(ThrottleManager.class);
    }

    public EcosPowerManager getPowerManager() {
        return (EcosPowerManager)this.get(PowerManager.class);
    }

    public EcosReporterManager getReporterManager() {
        return (EcosReporterManager)this.get(ReporterManager.class);
    }

    public EcosProgrammerManager getProgrammerManager() {
        return (EcosProgrammerManager)this.classObjectMap.computeIfAbsent(EcosProgrammerManager.class, c -> new EcosProgrammerManager((Programmer)new EcosProgrammer(this.getTrafficController()), this));
    }

    @Override
    public void dispose() {
        EcosPreferences prefManager;
        EcosLocoAddressManager locoManager = this.get(EcosLocoAddressManager.class);
        if (locoManager != null) {
            locoManager.dispose();
            this.deregister(locoManager, EcosLocoAddressManager.class);
        }
        this.et = null;
        InstanceManager.deregister(this, EcosSystemConnectionMemo.class);
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
        }
        if ((prefManager = this.get(EcosPreferences.class)) != null) {
            InstanceManager.getDefault(ShutDownManager.class).deregister(prefManager.ecosPreferencesShutDownTask);
            this.deregister(prefManager, EcosPreferences.class);
        }
        super.dispose();
    }
}

