/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos.networkdriver;

import jmri.jmrix.ecos.EcosPortController;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.EcosTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkDriverAdapter
extends EcosPortController {
    private static final Logger log = LoggerFactory.getLogger(NetworkDriverAdapter.class);

    public NetworkDriverAdapter(EcosSystemConnectionMemo memo) {
        super(memo);
        this.allowConnectionRecovery = true;
        this.manufacturerName = "ESU";
    }

    public NetworkDriverAdapter() {
        this(new EcosSystemConnectionMemo());
    }

    @Override
    public void configure() {
        EcosTrafficController control = new EcosTrafficController();
        control.connectPort(this);
        control.setAdapterMemo(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().setEcosTrafficController(control);
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    protected void resetupConnection() {
        log.info("reconnected to ECoS after lost connection");
        if (this.opened) {
            this.getSystemConnectionMemo().getTrafficController().connectPort(this);
            this.getSystemConnectionMemo().getTurnoutManager().refreshItems();
            this.getSystemConnectionMemo().getSensorManager().refreshItems();
            this.getSystemConnectionMemo().getLocoAddressManager().refreshItems();
        }
    }
}

