/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos.swing;

import javax.swing.JMenu;
import javax.swing.JSeparator;
import jmri.InstanceManager;
import jmri.jmrit.beantable.ListedTableAction;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.swing.Bundle;
import jmri.jmrix.ecos.swing.EcosNamedPaneAction;
import jmri.jmrix.ecos.utilities.AddRosterEntryToEcos;
import jmri.util.prefs.JmriPreferencesActionFactory;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class EcosMenu
extends JMenu {
    Item[] panelItems = new Item[]{new Item("MenuItemEcosMonitor", "jmri.jmrix.ecos.swing.monitor.EcosMonPane"), new Item("MenuItemSendPacket", "jmri.jmrix.ecos.swing.packetgen.PacketGenPanel"), new Item("MenuItemInfo", "jmri.jmrix.ecos.swing.statusframe.StatusPanel")};

    public EcosMenu(EcosSystemConnectionMemo memo) {
        String title = memo != null ? memo.getUserName() : Bundle.getMessage("MenuEcos");
        this.setText(title);
        JmriJFrameInterface wi = new JmriJFrameInterface();
        for (Item item : this.panelItems) {
            if (item == null) {
                this.add(new JSeparator());
                continue;
            }
            this.add(new EcosNamedPaneAction(Bundle.getMessage(item.name), (WindowInterface)wi, item.load, memo));
        }
        this.add(new ListedTableAction(Bundle.getMessage("MenuItemDatabase"), "jmri.jmrix.ecos.swing.locodatabase.EcosLocoTableTabAction"));
        this.add(InstanceManager.getDefault(JmriPreferencesActionFactory.class).getCategorizedAction(Bundle.getMessage("MenuItemECoSPrefs"), "ECoS", title));
        if (memo != null) {
            this.add(new AddRosterEntryToEcos(Bundle.getMessage("MenuItemAddLocoToEcos"), memo));
        }
    }

    static class Item {
        String name;
        String load;

        Item(String name, String load) {
            this.name = name;
            this.load = load;
        }
    }
}

