/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos.swing.locodatabase;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.GlobalRosterEntryComboBox;
import jmri.jmrix.ecos.EcosLocoAddress;
import jmri.jmrix.ecos.EcosLocoAddressManager;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.swing.locodatabase.Bundle;
import jmri.jmrix.ecos.swing.locodatabase.EcosLocoTableTabAction;
import jmri.jmrix.ecos.utilities.EcosLocoToRoster;
import jmri.jmrix.ecos.utilities.RemoveObjectFromEcos;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.XTableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosLocoTableAction
extends AbstractTableAction<NamedBean> {
    protected EcosSystemConnectionMemo adaptermemo;
    protected EcosLocoAddressManager locoManager;
    protected String rosterAttribute;
    List<String> ecosObjectIdList = null;
    JTable table;
    public static final int PROTOCOL = 5;
    public static final int ADDTOROSTERCOL = 6;
    public static final int SPEEDDIR = 7;
    public static final int STOP = 8;
    boolean showLocoMonitor = false;
    JCheckBox showMonitorLoco = new JCheckBox("Monitor Loco Speed");
    private static final Logger log = LoggerFactory.getLogger(EcosLocoTableAction.class);

    public EcosLocoTableAction(String s) {
        super(s);
    }

    public EcosLocoTableAction() {
        this(Bundle.getMessage("EcosLocoTableTitle"));
    }

    public EcosLocoTableAction(String s, EcosSystemConnectionMemo memo) {
        this(s);
        this.setAdapterMemo(memo);
        this.includeAddButton = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.createModel();
        TableRowSorter<BeanTableDataModel> sorter = new TableRowSorter<BeanTableDataModel>(this.m);
        JTable dataTable = this.m.makeJTable(this.getClassName(), this.m, sorter);
        this.f = new BeanTableFrame<NamedBean>(this.m, this.helpTarget(), dataTable){};
        this.setMenuBar(this.f);
        this.setTitle();
        this.addToFrame(this.f);
        this.f.pack();
        this.f.setVisible(true);
    }

    @Override
    public void setManager(Manager<NamedBean> man) {
        if (!(man instanceof EcosLocoAddressManager)) {
            throw new IllegalArgumentException("Manager is not an EcosLocoAddressManager");
        }
        this.locoManager = (EcosLocoAddressManager)man;
    }

    public void setAdapterMemo(EcosSystemConnectionMemo memo) {
        this.adaptermemo = memo;
        this.locoManager = this.adaptermemo.getLocoAddressManager();
        this.rosterAttribute = this.adaptermemo.getPreferenceManager().getRosterAttribute();
    }

    protected EcosLocoAddress getByEcosObject(String object) {
        return this.locoManager.getByEcosObject(object);
    }

    @Override
    protected void createModel() {
        this.m = new BeanTableDataModel<NamedBean>(){

            protected EcosLocoAddressManager getManager() {
                return EcosLocoTableAction.this.locoManager;
            }

            protected String getRosterAttribute() {
                return EcosLocoTableAction.this.rosterAttribute;
            }

            @Override
            public String getValue(String s) {
                return Bundle.getMessage("ButtonSet");
            }

            @Override
            protected String getMasterClassName() {
                return EcosLocoTableAction.this.getClassName();
            }

            @Override
            public void clickOn(NamedBean t) {
            }

            @Override
            protected synchronized void updateNameList() {
                int i;
                if (EcosLocoTableAction.this.ecosObjectIdList != null) {
                    for (i = 0; i < EcosLocoTableAction.this.ecosObjectIdList.size(); ++i) {
                        EcosLocoAddress b = EcosLocoTableAction.this.getByEcosObject(EcosLocoTableAction.this.ecosObjectIdList.get(i));
                        if (b == null) continue;
                        b.removePropertyChangeListener(this);
                    }
                }
                EcosLocoTableAction.this.ecosObjectIdList = this.getManager().getEcosObjectList();
                for (i = 0; i < EcosLocoTableAction.this.ecosObjectIdList.size(); ++i) {
                    EcosLocoTableAction.this.getByEcosObject(EcosLocoTableAction.this.ecosObjectIdList.get(i)).addPropertyChangeListener(this);
                }
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                this.updateNameList();
                if (e.getPropertyName().equals("length")) {
                    this.updateNameList();
                    this.fireTableDataChanged();
                } else if (this.matchPropertyName(e)) {
                    String object = ((EcosLocoAddress)e.getSource()).getEcosObject();
                    int row = EcosLocoTableAction.this.ecosObjectIdList.indexOf(object);
                    this.fireTableRowsUpdated(row, row);
                }
            }

            @Override
            public int getColumnCount() {
                return 9;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                if (col == 3) {
                    List<RosterEntry> r;
                    String ecosObjectNo = EcosLocoTableAction.this.ecosObjectIdList.get(row);
                    if (value == null) {
                        return;
                    }
                    if (value instanceof RosterEntry) {
                        RosterEntry oldre;
                        RosterEntry re = (RosterEntry)value;
                        if (re.getAttribute(this.getRosterAttribute()) != null && !re.getAttribute(this.getRosterAttribute()).equals("")) {
                            JmriJOptionPane.showMessageDialog(EcosLocoTableAction.this.f, Bundle.getMessage("EcosEditAssignedDialog", ecosObjectNo));
                            log.error("{} This roster entry already has an ECoS loco assigned to it", (Object)ecosObjectNo);
                            return;
                        }
                        String oldRoster = EcosLocoTableAction.this.getByEcosObject(ecosObjectNo).getRosterId();
                        if (oldRoster != null && (oldre = Roster.getDefault().getEntryForId(oldRoster)) != null) {
                            oldre.deleteAttribute(this.getRosterAttribute());
                        }
                        re.putAttribute(this.getRosterAttribute(), ecosObjectNo);
                        EcosLocoTableAction.this.getByEcosObject(ecosObjectNo).setRosterId(re.getId());
                        re.updateFile();
                    } else if (value instanceof String && (r = Roster.getDefault().getEntriesWithAttributeKeyValue(this.getRosterAttribute(), ecosObjectNo)).isEmpty()) {
                        r.get(0).deleteAttribute(this.getRosterAttribute());
                        EcosLocoTableAction.this.getByEcosObject(ecosObjectNo).setRosterId(null);
                        r.get(0).updateFile();
                    }
                    Roster.getDefault().writeRoster();
                } else if (col == 6) {
                    EcosLocoTableAction.this.addToRoster(row, col);
                } else if (col == 8) {
                    EcosLocoTableAction.this.stopLoco(row, col);
                } else if (col == 4) {
                    this.deleteLoco(row, col);
                } else if (col == 1) {
                    EcosLocoAddress b = EcosLocoTableAction.this.getByEcosObject(EcosLocoTableAction.this.ecosObjectIdList.get(row));
                    EcosMessage m = new EcosMessage("request(" + b.getEcosObject() + ", control, force)");
                    EcosLocoTableAction.this.adaptermemo.getTrafficController().sendEcosMessage(m, null);
                    m = new EcosMessage("set(" + b.getEcosObject() + ", name[\"" + (String)value + "\"])");
                    EcosLocoTableAction.this.adaptermemo.getTrafficController().sendEcosMessage(m, null);
                    m = new EcosMessage("release(" + b.getEcosObject() + ", control)");
                    EcosLocoTableAction.this.adaptermemo.getTrafficController().sendEcosMessage(m, null);
                }
            }

            @Override
            public JTable makeJTable(@Nonnull String name, @Nonnull TableModel model, @CheckForNull RowSorter<? extends TableModel> sorter) {
                return this.configureJTable(name, this.makeJTable(model), sorter);
            }

            private JTable makeJTable(@Nonnull TableModel model) {
                JTable table = new JTable(model){
                    Hashtable<Object, TableCellRenderer> rendererMap;
                    Hashtable<Object, TableCellEditor> editorMap;
                    {
                        this.rendererMap = new Hashtable();
                        this.editorMap = new Hashtable();
                    }

                    @Override
                    public TableCellRenderer getCellRenderer(int row, int column) {
                        if (column == 3) {
                            return this.getRenderer(row);
                        }
                        return super.getCellRenderer(row, column);
                    }

                    @Override
                    public TableCellEditor getCellEditor(int row, int column) {
                        if (column == 3) {
                            return this.getEditor(row);
                        }
                        return super.getCellEditor(row, column);
                    }

                    TableCellRenderer getRenderer(int row) {
                        TableCellRenderer retval = this.rendererMap.get(EcosLocoTableAction.this.ecosObjectIdList.get(row));
                        if (retval == null) {
                            EcosLocoAddress b = EcosLocoTableAction.this.getByEcosObject(EcosLocoTableAction.this.ecosObjectIdList.get(row));
                            RosterEntry re = null;
                            if (b != null) {
                                re = Roster.getDefault().getEntryForId(b.getRosterId());
                            }
                            retval = new RosterBoxRenderer(re);
                            this.rendererMap.put(EcosLocoTableAction.this.ecosObjectIdList.get(row), retval);
                        }
                        return retval;
                    }

                    TableCellEditor getEditor(int row) {
                        TableCellEditor retval = this.editorMap.get(EcosLocoTableAction.this.ecosObjectIdList.get(row));
                        if (retval == null) {
                            EcosLocoAddress b = EcosLocoTableAction.this.getByEcosObject(EcosLocoTableAction.this.ecosObjectIdList.get(row));
                            RosterEntry re = null;
                            if (b != null) {
                                re = Roster.getDefault().getEntryForId(b.getRosterId());
                            }
                            GlobalRosterEntryComboBox cb = new GlobalRosterEntryComboBox();
                            cb.setNonSelectedItem(" ");
                            if (re == null) {
                                cb.setSelectedIndex(0);
                            } else {
                                cb.setSelectedItem(re);
                            }
                            retval = new RosterComboBoxEditor(cb);
                            this.editorMap.put(EcosLocoTableAction.this.ecosObjectIdList.get(row), retval);
                        }
                        return retval;
                    }
                };
                table.getTableHeader().setReorderingAllowed(true);
                table.setColumnModel(new XTableColumnModel());
                table.createDefaultColumnsFromModel();
                this.addMouseListenerToHeader(table);
                return table;
            }

            @Override
            protected boolean matchPropertyName(PropertyChangeEvent e) {
                return EcosLocoTableAction.this.showLocoMonitor || !e.getPropertyName().equals("Speed") && !e.getPropertyName().equals("Direction");
            }

            @Override
            public String getColumnName(int col) {
                switch (col) {
                    case 0: {
                        return Bundle.getMessage("ObjectIdCol");
                    }
                    case 1: {
                        return Bundle.getMessage("DescriptionCol");
                    }
                    case 2: {
                        return Bundle.getMessage("AddressCol");
                    }
                    case 3: {
                        return Bundle.getMessage("JmriIdCol");
                    }
                    case 4: {
                        return "";
                    }
                    case 5: {
                        return Bundle.getMessage("ProtocolCol");
                    }
                    case 6: {
                        return "";
                    }
                    case 7: {
                        return Bundle.getMessage("SpeedCol") + " " + Bundle.getMessage("DirectionCol");
                    }
                    case 8: {
                        return "";
                    }
                }
                return "unknown";
            }

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 0: 
                    case 1: 
                    case 5: 
                    case 7: {
                        return String.class;
                    }
                    case 2: {
                        return Integer.class;
                    }
                    case 4: 
                    case 6: 
                    case 8: {
                        return JButton.class;
                    }
                    case 3: {
                        return JComboBox.class;
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                switch (col) {
                    case 3: {
                        return true;
                    }
                    case 6: {
                        EcosLocoAddress b = EcosLocoTableAction.this.getByEcosObject(EcosLocoTableAction.this.ecosObjectIdList.get(row));
                        return b.getRosterId() == null || b.getRosterId().equals("");
                    }
                    case 1: 
                    case 4: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="better to keep cases in column order rather than to combine")
            public int getPreferredWidth(int col) {
                switch (col) {
                    case 0: {
                        return new JTextField((int)5).getPreferredSize().width;
                    }
                    case 3: {
                        return new JTextField((int)20).getPreferredSize().width;
                    }
                    case 1: {
                        return new JTextField((int)20).getPreferredSize().width;
                    }
                    case 6: {
                        return new JTextField((int)12).getPreferredSize().width;
                    }
                    case 8: {
                        return new JTextField((int)6).getPreferredSize().width;
                    }
                    case 2: {
                        return new JTextField((int)5).getPreferredSize().width;
                    }
                    case 7: {
                        return new JTextField((int)10).getPreferredSize().width;
                    }
                    case 5: {
                        return new JTextField((int)5).getPreferredSize().width;
                    }
                }
                return super.getPreferredWidth(col);
            }

            @Override
            public void configureTable(JTable tbl) {
                EcosLocoTableAction.this.table = tbl;
                this.setColumnToHoldButton(EcosLocoTableAction.this.table, 6, new JButton(Bundle.getMessage("ButtonAddRoster")));
                this.setColumnToHoldButton(EcosLocoTableAction.this.table, 8, EcosLocoTableAction.this.stopButton());
                super.configureTable(EcosLocoTableAction.this.table);
                XTableColumnModel columnModel = (XTableColumnModel)EcosLocoTableAction.this.table.getColumnModel();
                TableColumn column = columnModel.getColumnByModelIndex(7);
                columnModel.setColumnVisible(column, false);
                column = columnModel.getColumnByModelIndex(8);
                columnModel.setColumnVisible(column, false);
            }

            @Override
            public NamedBean getBySystemName(@Nonnull String name) {
                return null;
            }

            @Override
            public NamedBean getByUserName(@Nonnull String name) {
                return null;
            }

            @Override
            public synchronized void dispose() {
                EcosLocoTableAction.this.showLocoMonitor = false;
                this.getManager().removePropertyChangeListener(this);
                if (EcosLocoTableAction.this.ecosObjectIdList != null) {
                    for (int i = 0; i < EcosLocoTableAction.this.ecosObjectIdList.size(); ++i) {
                        EcosLocoAddress b = EcosLocoTableAction.this.getByEcosObject(EcosLocoTableAction.this.ecosObjectIdList.get(i));
                        if (b == null) continue;
                        b.removePropertyChangeListener(this);
                    }
                }
            }

            protected void deleteLoco(final int row, int col) {
                if (row >= EcosLocoTableAction.this.ecosObjectIdList.size()) {
                    log.debug("row is greater than list size");
                    return;
                }
                EcosLocoAddress b = EcosLocoTableAction.this.getByEcosObject(EcosLocoTableAction.this.ecosObjectIdList.get(row));
                final JDialog dialog = new JDialog();
                dialog.setTitle(Bundle.getMessage("RemoveLocoTitle"));
                dialog.setLocation(300, 200);
                dialog.setDefaultCloseOperation(2);
                JPanel container = new JPanel();
                container.setLayout(new BoxLayout(container, 1));
                container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                JLabel question = new JLabel(Bundle.getMessage("RemoveLocoXDialog", b.getEcosDescription()));
                question.setAlignmentX(0.5f);
                container.add(question);
                JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
                JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
                JPanel button = new JPanel();
                button.setAlignmentX(0.5f);
                button.add(yesButton);
                button.add(noButton);
                container.add(button);
                noButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.dispose();
                    }
                });
                yesButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RemoveObjectFromEcos removeObjectFromEcos = new RemoveObjectFromEcos();
                        removeObjectFromEcos.removeObjectFromEcos(EcosLocoTableAction.this.ecosObjectIdList.get(row), EcosLocoTableAction.this.adaptermemo.getTrafficController());
                        dialog.dispose();
                    }
                });
                container.setAlignmentX(0.5f);
                container.setAlignmentY(0.5f);
                dialog.getContentPane().add(container);
                dialog.pack();
                dialog.setModal(true);
                dialog.setVisible(true);
            }

            @Override
            public int getRowCount() {
                return EcosLocoTableAction.this.ecosObjectIdList.size();
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (row >= EcosLocoTableAction.this.ecosObjectIdList.size()) {
                    log.debug("row is greater than list size");
                    return null;
                }
                switch (col) {
                    case 0: {
                        return EcosLocoTableAction.this.ecosObjectIdList.get(row);
                    }
                    case 1: {
                        EcosLocoAddress b = EcosLocoTableAction.this.getByEcosObject(EcosLocoTableAction.this.ecosObjectIdList.get(row));
                        return b != null ? b.getEcosDescription() : null;
                    }
                    case 2: {
                        EcosLocoAddress b = EcosLocoTableAction.this.getByEcosObject(EcosLocoTableAction.this.ecosObjectIdList.get(row));
                        return b != null ? Integer.valueOf(b.getNumber()) : null;
                    }
                    case 3: {
                        EcosLocoAddress b = EcosLocoTableAction.this.getByEcosObject(EcosLocoTableAction.this.ecosObjectIdList.get(row));
                        RosterEntry re = null;
                        if (b != null) {
                            re = Roster.getDefault().getEntryForId(b.getRosterId());
                        }
                        GlobalRosterEntryComboBox cb = (GlobalRosterEntryComboBox)((Object)EcosLocoTableAction.this.table.getCellRenderer(row, col));
                        if (re == null) {
                            cb.setSelectedIndex(0);
                        } else {
                            cb.setSelectedItem(re);
                        }
                        return re;
                    }
                    case 5: {
                        EcosLocoAddress b = EcosLocoTableAction.this.getByEcosObject(EcosLocoTableAction.this.ecosObjectIdList.get(row));
                        return b != null ? b.getECOSProtocol() : null;
                    }
                    case 6: {
                        EcosLocoAddress b = EcosLocoTableAction.this.getByEcosObject(EcosLocoTableAction.this.ecosObjectIdList.get(row));
                        if (b.getRosterId() == null || b.getRosterId().equals("")) {
                            return Bundle.getMessage("ButtonAddRoster");
                        }
                        return " ";
                    }
                    case 8: {
                        return Bundle.getMessage("ButtonStop");
                    }
                    case 7: {
                        EcosLocoAddress b = EcosLocoTableAction.this.getByEcosObject(EcosLocoTableAction.this.ecosObjectIdList.get(row));
                        return b != null ? b.getDirectionAsString() + " : " + b.getSpeed() : null;
                    }
                    case 4: {
                        return Bundle.getMessage("ButtonDelete");
                    }
                }
                return null;
            }

            @Override
            protected String getBeanType() {
                return Bundle.getMessage("EcosLocoTitle");
            }

            @Override
            protected void showPopup(JmriMouseEvent e) {
            }
        };
    }

    void showMonitorChanged() {
        this.showLocoMonitor = this.showMonitorLoco.isSelected();
        XTableColumnModel columnModel = (XTableColumnModel)this.table.getColumnModel();
        TableColumn column = columnModel.getColumnByModelIndex(7);
        columnModel.setColumnVisible(column, this.showLocoMonitor);
        column = columnModel.getColumnByModelIndex(8);
        columnModel.setColumnVisible(column, this.showLocoMonitor);
    }

    protected JButton stopButton() {
        JButton stopButton = new JButton("STOP");
        return stopButton;
    }

    void stopLoco(int row, int col) {
        String objectNumber = this.ecosObjectIdList.get(row);
        for (int x = 0; x < 3; ++x) {
            EcosMessage msg = new EcosMessage("request(" + objectNumber + ", control, force)");
            this.adaptermemo.getTrafficController().sendEcosMessage(msg, null);
            msg = new EcosMessage("set(" + objectNumber + ", stop)");
            this.adaptermemo.getTrafficController().sendEcosMessage(msg, null);
            msg = new EcosMessage("release(" + objectNumber + ", control)");
            this.adaptermemo.getTrafficController().sendEcosMessage(msg, null);
        }
    }

    public void addToPanel(EcosLocoTableTabAction f) {
        f.addToBottomBox(this.showMonitorLoco, this.adaptermemo.getUserName());
        this.showMonitorLoco.setToolTipText("Show extra columns for configuring turnout feedback?");
        this.showMonitorLoco.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcosLocoTableAction.this.showMonitorChanged();
            }
        });
    }

    void addToRoster(int row, int col) {
        if (this.getByEcosObject(this.ecosObjectIdList.get(row)).getRosterId() == null) {
            EcosLocoToRoster addLoco = new EcosLocoToRoster(this.adaptermemo);
            this.getByEcosObject(this.ecosObjectIdList.get(row)).allowAddToRoster();
            addLoco.addToQueue(this.getByEcosObject(this.ecosObjectIdList.get(row)));
            addLoco.processQueue();
            this.m.fireTableRowsUpdated(row, row);
        }
    }

    @Override
    protected void setTitle() {
        if (this.adaptermemo != null) {
            this.f.setTitle(Bundle.getMessage("XLocoTableTitle", this.adaptermemo.getUserName()));
        }
        this.f.setTitle(Bundle.getMessage("EcosLocoTableTitle"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrix.ecos.swing.locodatabase.EcosLocoTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
    }

    @Override
    protected String getClassName() {
        return EcosLocoTableAction.class.getName();
    }

    static class RosterComboBoxEditor
    extends DefaultCellEditor {
        public RosterComboBoxEditor(GlobalRosterEntryComboBox cb) {
            super(cb);
        }
    }

    static class RosterBoxRenderer
    extends GlobalRosterEntryComboBox
    implements TableCellRenderer {
        public RosterBoxRenderer(RosterEntry re) {
            this.setNonSelectedItem(" ");
            if (re == null) {
                this.setSelectedIndex(0);
            } else {
                this.setSelectedItem(re);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (value == null) {
                this.setSelectedIndex(0);
            } else {
                this.setSelectedItem(value);
            }
            return this;
        }
    }
}

