/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos.swing.packetgen;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosTrafficController;
import jmri.jmrix.ecos.swing.EcosPanel;
import jmri.jmrix.ecos.swing.packetgen.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketGenPanel
extends EcosPanel {
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(20);
    private static final Logger log = LoggerFactory.getLogger(PacketGenPanel.class);

    @Override
    public void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.jLabel1.setText(Bundle.getMessage("CommandLabel"));
        this.jLabel1.setVisible(true);
        this.sendButton.setText(Bundle.getMessage("ButtonSend"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("SendToolTip"));
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText(Bundle.getMessage("EnterASCIIToolTip"));
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.add(this.jLabel1);
        this.add(this.packetTextField);
        this.add(this.sendButton);
        this.sendButton.addActionListener(this::sendButtonActionPerformed);
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.ecos.swing.packetgen.PacketGenFrame";
    }

    @Override
    public String getTitle() {
        if (this.memo != null) {
            return Bundle.getMessage("SendXCommandTitle", this.memo.getUserName());
        }
        return Bundle.getMessage("MenuItemSendPacket");
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        EcosMessage m = new EcosMessage(input.length());
        for (int i = 0; i < input.length(); ++i) {
            m.setElement(i, input.charAt(i));
        }
        if (this.memo == null) {
            log.error("no System Connection Memo Found when sending {}", (Object)m);
            return;
        }
        EcosTrafficController tc = this.memo.getTrafficController();
        if (tc == null) {
            log.error("no Traffic Controller for Memo {} when sending {}", (Object)this.memo.getUserName(), (Object)m);
            return;
        }
        tc.sendEcosMessage(m, null);
    }
}

