/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos.swing.statusframe;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrix.ecos.EcosListener;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosReply;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.EcosTrafficController;
import jmri.jmrix.ecos.swing.EcosNamedPaneAction;
import jmri.jmrix.ecos.swing.EcosPanel;
import jmri.jmrix.ecos.swing.statusframe.Bundle;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPanel
extends EcosPanel
implements EcosListener {
    JPanel statusPanel = new JPanel();
    String appString = Bundle.getMessage("ApplicationVersionLabel") + " ";
    String proString = Bundle.getMessage("ProtocolVersionLabel") + " ";
    String hrdString = Bundle.getMessage("HardwareVersionLabel") + " ";
    JLabel appVersion = new JLabel(this.appString + Bundle.getMessage("StateUnknown"));
    JLabel proVersion = new JLabel(this.proString + Bundle.getMessage("StateUnknown"));
    JLabel hrdVersion = new JLabel(this.hrdString + Bundle.getMessage("StateUnknown"));
    JButton sendButton;
    EcosTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(StatusPanel.class);

    @Override
    public void initComponents(EcosSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.tc = memo.getTrafficController();
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 1));
        this.statusPanel.setBorder(BorderFactory.createEtchedBorder());
        this.statusPanel.add(this.appVersion);
        this.statusPanel.add(this.proVersion);
        this.statusPanel.add(this.hrdVersion);
        this.add(this.statusPanel);
        try {
            this.tc.addEcosListener(this);
            EcosMessage m = new EcosMessage("request(1, view)");
            this.tc.sendEcosMessage(m, this);
            m = new EcosMessage("get(1, info)");
            this.tc.sendEcosMessage(m, this);
        }
        catch (NullPointerException npe) {
            log.warn("Could not connect to ECoS connection {}", (Object)memo);
        }
        this.sendButton = new JButton(Bundle.getMessage("ButtonUpdate"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("UpdateToolTip"));
        this.add(this.sendButton);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.sendButtonActionPerformed(e);
            }
        });
    }

    void reset() {
        this.appVersion.setText(this.appString + Bundle.getMessage("StateUnknown"));
        this.proVersion.setText(this.proString + Bundle.getMessage("StateUnknown"));
        this.hrdVersion.setText(this.hrdString + Bundle.getMessage("StateUnknown"));
    }

    @Override
    public void dispose() {
        this.tc.removeEcosListener(this);
        this.tc = null;
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        this.reset();
        try {
            EcosMessage m = new EcosMessage("get(1, info)");
            this.tc.sendEcosMessage(m, null);
        }
        catch (NullPointerException npe) {
            log.warn("Could not connect to ECoS connection {}", (Object)this.memo);
        }
    }

    @Override
    public void reply(EcosReply m) {
        String msg = m.toString();
        if ((msg.contains("<EVENT 1>") || msg.contains("REPLY get(1,")) && msg.contains("info")) {
            int last;
            int first = msg.indexOf("ProtocolVersion[");
            if (first > 0) {
                last = msg.indexOf("]", first + 16);
                this.proVersion.setText(this.proString + msg.substring(first + 16, last));
            }
            if ((first = msg.indexOf("ApplicationVersion[")) > 0) {
                last = msg.indexOf("]", first + 19);
                this.appVersion.setText(this.appString + msg.substring(first + 19, last));
            }
            if ((first = msg.indexOf("HardwareVersion[")) > 0) {
                last = msg.indexOf("]", first + 16);
                this.hrdVersion.setText(this.hrdString + msg.substring(first + 16, last));
            }
        }
    }

    @Override
    public void message(EcosMessage m) {
    }

    @Override
    public String getTitle() {
        if (this.memo != null) {
            return Bundle.getMessage("XInfoTitle", this.memo.getUserName());
        }
        return Bundle.getMessage("MenuItemInfo");
    }

    public static class Default
    extends EcosNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemInfo"), (WindowInterface)new JmriJFrameInterface(), StatusPanel.class.getName(), InstanceManager.getDefault(EcosSystemConnectionMemo.class));
        }
    }
}

