/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos.utilities;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import jmri.LocoAddress;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrix.ecos.EcosLocoAddress;
import jmri.jmrix.ecos.EcosLocoAddressManager;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.utilities.Bundle;
import jmri.jmrix.ecos.utilities.RosterToEcos;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRosterEntryToEcos
extends AbstractAction {
    private final EcosSystemConnectionMemo adaptermemo;
    private final EcosLocoAddressManager objEcosLocoManager;
    private final JComboBox<String> rosterEntry = new JComboBox();
    private Roster roster;
    private static final Logger log = LoggerFactory.getLogger(AddRosterEntryToEcos.class);

    public AddRosterEntryToEcos(String s, EcosSystemConnectionMemo memo) {
        super(s);
        this.adaptermemo = memo;
        this.objEcosLocoManager = this.adaptermemo.getLocoAddressManager();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.roster = Roster.getDefault();
        this.rosterEntryUpdate();
        int retval = JmriJOptionPane.showConfirmDialog(null, new Object[]{Bundle.getMessage("AddToEcosDialog"), this.rosterEntry}, Bundle.getMessage("AddToEcosTitle"), 2);
        log.debug("Dialog value {} selected, {}:{}", new Object[]{retval, this.rosterEntry.getSelectedIndex(), this.rosterEntry.getSelectedItem()});
        if (retval != 0 || this.rosterEntry.getItemCount() == 0) {
            return;
        }
        String selEntry = (String)this.rosterEntry.getSelectedItem();
        RosterEntry re = this.roster.entryFromTitle(selEntry);
        log.debug("Add {} to ECoS", (Object)re.getId());
        RosterToEcos rosterToEcos = new RosterToEcos(this.adaptermemo);
        rosterToEcos.createEcosLoco(re);
    }

    void rosterEntryUpdate() {
        this.rosterEntry.removeAllItems();
        for (RosterEntry r : this.roster.getAllEntries()) {
            String dccAddress = r.getDccAddress();
            EcosLocoAddress ecosAddress = null;
            if (dccAddress != null) {
                log.debug("DccAddress={}", (Object)dccAddress);
                try {
                    ecosAddress = this.objEcosLocoManager.getByDccAddress(Integer.parseInt(dccAddress));
                }
                catch (NullPointerException npe) {
                    log.warn("Could not connect to ECoS roster via objEcosLocoManager to loop up Loco {}", (Object)dccAddress);
                    return;
                }
            }
            if (ecosAddress != null || r.getProtocol() == LocoAddress.Protocol.MFX) continue;
            this.rosterEntry.addItem(r.titleString());
        }
    }
}

