/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrix.grapevine.Bundle;
import jmri.jmrix.grapevine.SerialNode;
import jmri.jmrix.grapevine.SerialTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialAddress {
    static final String turnoutRegex = "^\\w\\d*(T)(?:((\\d++)(B)(\\d++))|(\\d++))$";
    static volatile Pattern turnoutPattern = null;
    static final String lightRegex = "^\\w\\d*(L)(?:((\\d++)(B)(\\d++))|(\\d++))$";
    static volatile Pattern lightPattern = null;
    static final String headRegex = "^\\w\\d*(H)(?:((\\d++)(B)(\\d++))|(\\d++))$";
    static volatile Pattern headPattern = null;
    static final String sensorRegex = "^\\w\\d*(S)(?:((\\d++)([BbAaMmPpSs])(\\d++))|(\\d++))$";
    static volatile Pattern sensorPattern = null;
    static final String allRegex = "^\\w\\d*([SHLT])(?:((\\d++)([BbAaMmPpSs])(\\d++))|(\\d++))$";
    static volatile Pattern allPattern = null;
    private static final Logger log = LoggerFactory.getLogger(SerialAddress.class);

    static Pattern getTurnoutPattern() {
        if (turnoutPattern == null) {
            turnoutPattern = Pattern.compile(turnoutRegex);
        }
        return turnoutPattern;
    }

    static Pattern getLightPattern() {
        if (lightPattern == null) {
            lightPattern = Pattern.compile(lightRegex);
        }
        return lightPattern;
    }

    static Pattern getHeadPattern() {
        if (headPattern == null) {
            headPattern = Pattern.compile(headRegex);
        }
        return headPattern;
    }

    static Pattern getSensorPattern() {
        if (sensorPattern == null) {
            sensorPattern = Pattern.compile(sensorRegex);
        }
        return sensorPattern;
    }

    static Pattern getAllPattern() {
        if (allPattern == null) {
            allPattern = Pattern.compile(allRegex);
        }
        return allPattern;
    }

    static int typeOffset(String type) {
        switch (type.toUpperCase().charAt(0)) {
            case 'B': {
                return 0;
            }
            case 'A': {
                return 100;
            }
            case 'M': {
                return 200;
            }
            case 'P': {
                return 0;
            }
            case 'S': {
                return 20;
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static SerialNode getNodeFromSystemName(String systemName, SerialTrafficController tc) {
        int ua;
        Matcher matcher = SerialAddress.getAllPattern().matcher(systemName);
        if (!matcher.matches()) {
            log.error("illegal system name format in getNodeFromSystemName: {}", (Object)systemName);
            return null;
        }
        if (matcher.group(6) == null) {
            ua = Integer.parseInt(matcher.group(3));
            return (SerialNode)tc.getNodeFromAddress(ua);
        }
        int num = Integer.parseInt(matcher.group(6));
        if (num > 0) {
            ua = num / 1000;
            return (SerialNode)tc.getNodeFromAddress(ua);
        }
        log.error("invalid value in system name: {}", (Object)systemName);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getBitFromSystemName(String systemName, String prefix) {
        Matcher matcher = SerialAddress.getAllPattern().matcher(systemName);
        if (!matcher.matches()) {
            log.error("illegal system name format in getBitFromSystemName: {} prefix: {}", new Object[]{systemName, prefix, new Exception("traceback")});
            return 0;
        }
        if (matcher.group(6) == null) return Integer.parseInt(matcher.group(5));
        int num = Integer.parseInt(matcher.group(6));
        if (num > 0) {
            return num % 1000;
        }
        log.error("invalid value in system name: {}", (Object)systemName);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getNodeAddressFromSystemName(String systemName, String prefix) {
        Matcher matcher = SerialAddress.getAllPattern().matcher(systemName);
        if (!matcher.matches()) {
            log.error("illegal system name format in getNodeAddressFromSystemName: {}", (Object)systemName);
            return -1;
        }
        if (matcher.group(6) != null) {
            int num = Integer.parseInt(matcher.group(6));
            if (num > 0) {
                return num / 1000;
            }
            log.error("invalid value in system name: {}", (Object)systemName);
            return -1;
        }
        int ua = Integer.parseInt(matcher.group(3));
        log.debug("node ua: {}", (Object)ua);
        return ua;
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="Passing Locale.ENGLISH Bundle exception text before stack trace")
    static String validateSystemNameFormat(String name, Manager<?> manager, Locale locale) {
        int bit;
        int node;
        Pattern pattern;
        name = manager.validateSystemNamePrefix(name, locale);
        switch (manager.typeLetter()) {
            case 'L': {
                pattern = SerialAddress.getLightPattern();
                break;
            }
            case 'T': {
                pattern = SerialAddress.getTurnoutPattern();
                break;
            }
            case 'H': {
                pattern = SerialAddress.getHeadPattern();
                break;
            }
            case 'S': {
                pattern = SerialAddress.getSensorPattern();
                break;
            }
            default: {
                NamedBean.BadSystemNameException ex = new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidUnknownType", name), Bundle.getMessage(locale, "SystemNameInvalidUnknownType", name));
                log.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
        Matcher matcher = pattern.matcher(name);
        if (!matcher.matches()) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameFailedRegex", name, pattern.pattern()), Bundle.getMessage(locale, "InvalidSystemNameFailedRegex", name, pattern.pattern()));
        }
        if (matcher.group(6) != null) {
            int num = Integer.parseInt(matcher.group(6));
            node = num / 1000;
            bit = num % 1000;
        } else {
            node = Integer.parseInt(matcher.group(3));
            bit = Integer.parseInt(matcher.group(5));
        }
        if (node < 1 || node > 127) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidNode", name, bit, 1, 127), Bundle.getMessage(locale, "SystemNameInvalidNode", name, bit, 1, 127));
        }
        if (manager.typeLetter() != 'S') {
            if (!(bit >= 101 && bit <= 124 || bit >= 201 && bit <= 224 || bit >= 301 && bit <= 324 || bit >= 401 && bit <= 424)) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameFailedRegex", name, pattern.pattern()), Bundle.getMessage(locale, "InvalidSystemNameFailedRegex", name, pattern.pattern()));
            }
        } else {
            String subtype = matcher.group(4);
            if (null == subtype) {
                if (bit < 1 || bit > 224) {
                    throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidBit", name, bit, 1, 224), Bundle.getMessage(locale, "SystemNameInvalidBit", name, bit, 1, 224));
                }
            } else {
                switch (subtype.toUpperCase()) {
                    case "A": {
                        if (bit >= 1 && bit <= 24) break;
                        throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidBit", name, bit, 1, 24), Bundle.getMessage(locale, "SystemNameInvalidBit", name, bit, 1, 24));
                    }
                    case "M": {
                        if (bit >= 1 && bit <= 24) break;
                        throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidBit", name, bit, 1, 24), Bundle.getMessage(locale, "SystemNameInvalidBit", name, bit, 1, 24));
                    }
                    case "S": {
                        if (bit >= 1 && bit <= 24) break;
                        throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidBit", name, bit, 1, 24), Bundle.getMessage(locale, "SystemNameInvalidBit", name, bit, 1, 24));
                    }
                    case "P": {
                        if (bit >= 1 && bit <= 96) break;
                        throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidBit", name, bit, 1, 96), Bundle.getMessage(locale, "SystemNameInvalidBit", name, bit, 1, 96));
                    }
                }
            }
        }
        return name;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Manager.NameValidity validSystemNameFormat(@Nonnull String systemName, char type, String prefix) {
        int bit;
        int node;
        Pattern p;
        Matcher matcher = SerialAddress.getAllPattern().matcher(systemName);
        if (!matcher.matches()) {
            return Manager.NameValidity.INVALID;
        }
        if (matcher.group(1).charAt(0) != type) {
            log.warn("type in {} does not match type {}", (Object)systemName, (Object)Character.valueOf(type));
            return Manager.NameValidity.INVALID;
        }
        switch (type) {
            case 'L': {
                p = SerialAddress.getLightPattern();
                break;
            }
            case 'T': {
                p = SerialAddress.getTurnoutPattern();
                break;
            }
            case 'H': {
                p = SerialAddress.getHeadPattern();
                break;
            }
            case 'S': {
                p = SerialAddress.getSensorPattern();
                break;
            }
            default: {
                log.error("cannot match type in {}, which is unexpected", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
        }
        matcher = p.matcher(systemName);
        if (!matcher.matches()) {
            log.debug("invalid system name format: {} for type {}", (Object)systemName, (Object)Character.valueOf(type));
            return Manager.NameValidity.INVALID;
        }
        if (matcher.group(6) != null) {
            int num = Integer.parseInt(matcher.group(6));
            if (num <= 0) {
                log.debug("invalid value in system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            node = num / 1000;
            bit = num % 1000;
        } else {
            node = Integer.parseInt(matcher.group(3));
            bit = Integer.parseInt(matcher.group(5));
        }
        if (node < 1 || node > 127) {
            log.debug("invalid node number {} in {}", (Object)node, (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        if (type == 'T' || type == 'H' || type == 'L') {
            if (bit >= 101 && bit <= 124 || bit >= 201 && bit <= 224 || bit >= 301 && bit <= 324 || bit >= 401 && bit <= 424) return Manager.NameValidity.VALID;
            log.debug("invalid bit number {} in {}", (Object)bit, (Object)systemName);
            return Manager.NameValidity.INVALID;
        } else {
            String subtype = matcher.group(4);
            if (subtype == null) {
                if (bit >= 1 && bit <= 224) {
                    return Manager.NameValidity.VALID;
                }
                log.debug("invalid bit number {} in {}", (Object)bit, (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            if ((subtype = subtype.toUpperCase()).equals("A")) {
                if (bit >= 1 && bit <= 24) return Manager.NameValidity.VALID;
                log.debug("invalid bit number {} in {}", (Object)bit, (Object)systemName);
                return Manager.NameValidity.INVALID;
            } else if (subtype.equals("M")) {
                if (bit >= 1 && bit <= 24) return Manager.NameValidity.VALID;
                log.debug("invalid bit number {} in  {}", (Object)bit, (Object)systemName);
                return Manager.NameValidity.INVALID;
            } else if (subtype.equals("S")) {
                if (bit >= 1 && bit <= 24) return Manager.NameValidity.VALID;
                log.debug("invalid bit number {} in {}", (Object)bit, (Object)systemName);
                return Manager.NameValidity.INVALID;
            } else {
                if (!subtype.equals("P") || bit >= 1 && bit <= 96) return Manager.NameValidity.VALID;
                log.debug("invalid bit number {} in {}", (Object)bit, (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
        }
    }

    public static boolean validSystemNameConfig(String systemName, char type, SerialTrafficController tc) {
        String prefix = tc.getSystemConnectionMemo().getSystemPrefix();
        if (SerialAddress.validSystemNameFormat(systemName, type, prefix) != Manager.NameValidity.VALID) {
            log.debug("invalid system name {}", (Object)systemName);
            return false;
        }
        SerialNode node = SerialAddress.getNodeFromSystemName(systemName, tc);
        if (node == null) {
            log.warn("invalid system name {}; no such node", (Object)systemName);
            return false;
        }
        int bit = SerialAddress.getBitFromSystemName(systemName, prefix);
        if (type == 'T' || type == 'L') {
            if (bit <= 0 || bit > SerialNode.outputBits[node.nodeType]) {
                log.warn("invalid system name {}; bad output bit number {} > {}", new Object[]{systemName, bit, SerialNode.outputBits[node.nodeType]});
                return false;
            }
        } else if (type == 'S') {
            if (bit <= 0 || bit > SerialNode.inputBits[node.nodeType]) {
                log.warn("invalid system name {}; bad input bit number {} > {}", new Object[]{systemName, bit, SerialNode.inputBits[node.nodeType]});
                return false;
            }
        } else {
            log.error("Invalid type specification in validSystemNameConfig call");
            return false;
        }
        return true;
    }

    public static String convertSystemNameToAlternate(String systemName, String prefix) {
        if (SerialAddress.validSystemNameFormat(systemName, systemName.charAt(prefix.length()), prefix) != Manager.NameValidity.VALID) {
            return "";
        }
        Matcher matcher = SerialAddress.getAllPattern().matcher(systemName);
        matcher.matches();
        if (matcher.group(6) != null) {
            int num = Integer.parseInt(matcher.group(6));
            return prefix + matcher.group(1) + num / 1000 + "B" + num % 1000;
        }
        int node = Integer.parseInt(matcher.group(3));
        int bit = Integer.parseInt(matcher.group(5));
        return prefix + matcher.group(1) + node + "B" + bit;
    }

    public static String normalizeSystemName(String systemName, String prefix) {
        try {
            if (SerialAddress.validSystemNameFormat(systemName, systemName.charAt(prefix.length()), prefix) != Manager.NameValidity.VALID) {
                return "";
            }
            Matcher matcher = SerialAddress.getAllPattern().matcher(systemName);
            matcher.matches();
            if (matcher.group(6) != null) {
                int num = Integer.parseInt(matcher.group(6));
                return prefix + matcher.group(1) + num;
            }
            int offset = SerialAddress.typeOffset(matcher.group(4));
            int node = Integer.parseInt(matcher.group(3));
            int bit = Integer.parseInt(matcher.group(5));
            return prefix + matcher.group(1) + (node * 1000 + bit + offset);
        }
        catch (StringIndexOutOfBoundsException sobe) {
            throw new IllegalArgumentException("Invalid System Name Format: " + systemName);
        }
    }
}

