/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Light;
import jmri.Manager;
import jmri.jmrix.grapevine.Bundle;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialAddress;
import jmri.jmrix.grapevine.SerialLight;
import jmri.managers.AbstractLightManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialLightManager
extends AbstractLightManager {
    private static final Logger log = LoggerFactory.getLogger(SerialLightManager.class);

    public SerialLightManager(GrapevineSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public GrapevineSystemConnectionMemo getMemo() {
        return (GrapevineSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Light createNewLight(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String prefix = this.getSystemPrefix();
        if (SerialAddress.validSystemNameFormat(systemName, 'L', prefix) == Manager.NameValidity.VALID) {
            SerialLight lgt = new SerialLight(systemName, userName, this.getMemo());
            if (!SerialAddress.validSystemNameConfig(systemName, 'L', this.getMemo().getTrafficController())) {
                log.warn("Light system Name does not refer to configured hardware: {}", (Object)systemName);
            }
            log.debug("new light {} for prefix {}", (Object)systemName, (Object)prefix);
            return lgt;
        }
        log.warn("Invalid Light system Name format: {}", (Object)systemName);
        throw new IllegalArgumentException("Invalid Light system Name format: " + systemName);
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return SerialAddress.validateSystemNameFormat(name, this, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return SerialAddress.validSystemNameFormat(systemName, this.typeLetter(), this.getSystemPrefix());
    }

    @Override
    public boolean validSystemNameConfig(@Nonnull String systemName) {
        return SerialAddress.validSystemNameConfig(systemName, 'L', this.getMemo().getTrafficController());
    }

    @Override
    @Nonnull
    public String convertSystemNameToAlternate(@Nonnull String systemName) {
        return SerialAddress.convertSystemNameToAlternate(systemName, this.getSystemPrefix());
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

