/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.Sensor;
import jmri.jmrix.grapevine.Bundle;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialAddress;
import jmri.jmrix.grapevine.SerialListener;
import jmri.jmrix.grapevine.SerialMessage;
import jmri.jmrix.grapevine.SerialNode;
import jmri.jmrix.grapevine.SerialReply;
import jmri.jmrix.grapevine.SerialSensor;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialSensorManager
extends AbstractSensorManager
implements SerialListener {
    static final int SENSORSPERNODE = 1000;
    private static final Logger log = LoggerFactory.getLogger(SerialSensorManager.class);

    public SerialSensorManager(GrapevineSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public GrapevineSystemConnectionMemo getMemo() {
        return (GrapevineSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String prefix = this.getSystemPrefix();
        log.debug("createNewSensor {} {}", (Object)systemName, (Object)userName);
        String sName = SerialAddress.normalizeSystemName(systemName, prefix);
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("Invalid Grapevine Sensor system name - " + systemName);
        }
        Sensor s = this.getBySystemName(sName);
        if (s != null) {
            throw new IllegalArgumentException("Grapevine Sensor with this name already exists - " + systemName);
        }
        String altName = SerialAddress.convertSystemNameToAlternate(sName, prefix);
        s = this.getBySystemName(altName);
        if (s != null) {
            throw new IllegalArgumentException("Grapevine Sensor with name  " + systemName + " already exists as " + altName);
        }
        int bit = SerialAddress.getBitFromSystemName(sName, prefix);
        if (bit <= 0 || bit >= 1000) {
            throw new IllegalArgumentException("Sensor bit number " + Integer.toString(bit) + " is outside the supported range 1-" + Integer.toString(999));
        }
        s = userName == null ? new SerialSensor(sName, this.getMemo()) : new SerialSensor(sName, userName, this.getMemo());
        SerialNode node = SerialAddress.getNodeFromSystemName(sName, this.getMemo().getTrafficController());
        if (node == null) {
            log.warn("Sensor {} refers to an undefined Serial Node.", (Object)sName);
            return s;
        }
        node.registerSensor(s, bit);
        log.debug("registered {}  in node {}", (Object)s.getSystemName(), (Object)node);
        return s;
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        String tmpSName = prefix + "S" + curAddress;
        try {
            this.validSystemNameFormat(tmpSName);
        }
        catch (IllegalArgumentException e) {
            throw new JmriException(e.toString());
        }
        log.debug("createSystemName {}", (Object)tmpSName);
        return tmpSName;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return SerialAddress.validateSystemNameFormat(name, this, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return SerialAddress.validSystemNameFormat(systemName, this.typeLetter(), this.getSystemPrefix());
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }

    @Override
    public void message(SerialMessage r) {
    }

    @Override
    public void reply(SerialReply r) {
        SerialNode node = (SerialNode)this.getMemo().getTrafficController().getNodeFromAddress(r.getAddr());
        if (node != null) {
            node.markChanges(r);
        }
        log.debug("node {} marked as changed by SerialSensorManager", (Object)r.getAddr());
    }

    public void registerSensorsForNode(SerialNode node) {
        for (Sensor s : this.getNamedBeanSet()) {
            SerialNode tNode;
            String sName = s.getSystemName();
            log.debug("System Name is {}", (Object)sName);
            if (!sName.startsWith(this.getSystemNamePrefix()) || (tNode = SerialAddress.getNodeFromSystemName(sName, this.getMemo().getTrafficController())) != node) continue;
            node.registerSensor(s, SerialAddress.getBitFromSystemName(sName, this.getSystemPrefix()));
        }
    }
}

