/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.IOException;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRNodeTrafficController;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialInterface;
import jmri.jmrix.grapevine.SerialListener;
import jmri.jmrix.grapevine.SerialMessage;
import jmri.jmrix.grapevine.SerialNode;
import jmri.jmrix.grapevine.SerialPortController;
import jmri.jmrix.grapevine.SerialReply;
import jmri.jmrix.grapevine.SerialSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTrafficController
extends AbstractMRNodeTrafficController
implements SerialInterface {
    boolean logDebug = false;
    SerialSensorManager mSensorManager = null;
    GrapevineSystemConnectionMemo mMemo = null;
    protected int currentAddr = -1;
    int nextReplyLen = 4;
    byte[] buffer = new byte[4];
    int state = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialTrafficController.class);

    public SerialTrafficController(GrapevineSystemConnectionMemo adaptermemo) {
        this.mMemo = adaptermemo;
        log.debug("creating a new GrapevineTrafficController object on {}", (Object)adaptermemo.getSystemPrefix());
        this.logDebug = log.isDebugEnabled();
        this.init(0, 255);
        this.setAllowUnexpectedReply(true);
        this.mWaitBeforePoll = 100;
    }

    public int getMinimumNodeAddress() {
        return this.minNode;
    }

    public void connectPort(SerialPortController p) {
        if (this.controller != null) {
            log.warn("connectPort called when already connected");
        } else {
            log.debug("connectPort invoked");
        }
        super.connectPort(p);
    }

    @Override
    public synchronized void addSerialListener(SerialListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeSerialListener(SerialListener l) {
        this.removeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSerialNode(SerialNode node) {
        SerialTrafficController serialTrafficController = this;
        synchronized (serialTrafficController) {
            for (int i = 0; i < this.getNumNodes(); ++i) {
                if (this.getNode(i) != node) continue;
                this.setMustInit(i, true);
                return;
            }
        }
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        log.warn("enterProgMode doesn't make sense for Grapevine Serial");
        return null;
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return null;
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((SerialListener)client).message((SerialMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply m) {
        ((SerialListener)client).reply((SerialReply)m);
    }

    public void setSensorManager(SerialSensorManager m) {
        this.mSensorManager = m;
        this.addSerialListener(m);
    }

    @Override
    protected synchronized AbstractMRMessage pollMessage() {
        if (this.getNumNodes() <= 0) {
            return null;
        }
        ++this.curSerialNodeIndex;
        if (this.curSerialNodeIndex >= this.getNumNodes()) {
            this.curSerialNodeIndex = 0;
        }
        if (this.getMustInit(this.curSerialNodeIndex)) {
            this.setMustInit(this.curSerialNodeIndex, false);
            SerialMessage m = (SerialMessage)this.getNode(this.curSerialNodeIndex).createInitPacket();
            if (m != null) {
                log.debug("send init message: {} to node {}", (Object)m.toString(), (Object)this.curSerialNodeIndex);
                m.setTimeout(50);
                return m;
            }
        }
        return null;
    }

    @Override
    protected synchronized void handleTimeout(AbstractMRMessage m, AbstractMRListener l) {
        if (this.getNode(this.curSerialNodeIndex) != null) {
            if (this.getNode(this.curSerialNodeIndex).handleTimeout(m, l)) {
                this.setMustInit(this.curSerialNodeIndex, true);
            } else {
                log.warn("Timeout can't be handled due to missing node (index {})", (Object)this.curSerialNodeIndex);
            }
        }
    }

    @Override
    protected synchronized void resetTimeout(AbstractMRMessage m) {
        this.getNode(this.curSerialNodeIndex).resetTimeout(m);
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return this.mSensorManager;
    }

    @Override
    public void sendSerialMessage(SerialMessage m, SerialListener reply) {
        if (m == null) {
            log.debug("empty message");
            return;
        }
        log.debug("Grapevine SerialTrafficController sendMessage() {}", (Object)m.toString());
        this.sendMessage(m, reply);
    }

    public GrapevineSystemConnectionMemo getSystemConnectionMemo() {
        return this.mMemo;
    }

    public void setSystemConnectionMemo(GrapevineSystemConnectionMemo m) {
        log.debug("GrapevineTrafficController set memo to {}", (Object)m.getUserName());
        this.mMemo = m;
    }

    @Override
    protected AbstractMRReply newReply() {
        return new SerialReply();
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        log.error("Not using endOfMessage, should not be called");
        return false;
    }

    @Override
    protected void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        this.nextReplyLen = ((SerialMessage)m).getReplyLen();
        super.forwardToPort(m, reply);
    }

    @Override
    protected void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        while (this.doNextStep(msg, istream)) {
        }
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    boolean doNextStep(AbstractMRReply msg, DataInputStream istream) throws IOException {
        switch (this.state) {
            case 0: {
                this.buffer[0] = this.readByteProtected(istream);
                log.debug("state 0, rcv {}", (Object)(this.buffer[0] & 0xFF));
                if ((this.buffer[0] & 0x80) == 0) {
                    log.warn("1st byte not address: {}", (Object)(this.buffer[0] & 0xFF));
                    return true;
                }
                this.state = 1;
            }
            case 1: {
                this.buffer[1] = this.readByteProtected(istream);
                log.debug("state 1, rcv {}", (Object)(this.buffer[1] & 0xFF));
                if ((this.buffer[1] & 0x80) != 0) {
                    this.buffer[0] = this.buffer[1];
                    this.state = 1;
                    log.warn("2nd byte HOB set: {}, going to state 1", (Object)(this.buffer[1] & 0xFF));
                    return true;
                }
                this.state = 2;
            }
            case 2: {
                if (this.nextReplyLen == 2) {
                    this.buffer[2] = 0;
                    this.buffer[3] = 0;
                    this.loadBuffer(msg);
                    ((SerialReply)msg).setNumDataElements(2);
                    this.nextReplyLen = 4;
                    this.state = 0;
                    log.debug("Short message complete: {}", (Object)msg.toString());
                    return false;
                }
                this.buffer[2] = this.readByteProtected(istream);
                log.debug("state 2, rcv {}", (Object)(this.buffer[2] & 0xFF));
                if (this.buffer[0] != this.buffer[2]) {
                    log.warn("addresses don't match: {}, {}. going to state 1", (Object)(this.buffer[0] & 0xFF), (Object)(this.buffer[2] & 0xFF));
                    this.buffer[0] = this.buffer[2];
                    this.state = 1;
                    return true;
                }
                this.state = 3;
            }
            case 3: {
                this.buffer[3] = this.readByteProtected(istream);
                log.debug("state 3, rcv {}", (Object)(this.buffer[3] & 0xFF));
                if ((this.buffer[3] & 0x80) != 0) {
                    this.buffer[0] = this.buffer[3];
                    this.state = 1;
                    log.warn("3rd byte HOB set: {}, going to state 1", (Object)(this.buffer[3] & 0xFF));
                    return true;
                }
                boolean pollMsg = this.buffer[1] == this.buffer[3] && this.buffer[1] == 119;
                boolean errMsg = (this.buffer[0] & 0xFF) == 128;
                int parity = (this.buffer[0] & 0xF) + ((this.buffer[0] & 0x70) >> 4) + (this.buffer[1] * 2 & 0xF) + ((this.buffer[1] * 2 & 0xF0) >> 4) + (this.buffer[3] & 0xF) + ((this.buffer[3] & 0x70) >> 4);
                if ((parity & 0xF) != 0 && !pollMsg && !errMsg) {
                    log.warn("parity mismatch: {}, going to state 2 with content {}, {}", new Object[]{parity, this.buffer[2] & 0xFF, this.buffer[3] & 0xFF});
                    this.buffer[0] = this.buffer[2];
                    this.buffer[1] = this.buffer[3];
                    this.state = 2;
                    return true;
                }
                this.loadBuffer(msg);
                log.debug("Message complete: {}", (Object)msg.toString());
                this.state = 0;
                return false;
            }
        }
        log.error("unexpected loadChars state: {}. go direct to state 0", (Object)this.state);
        this.state = 0;
        return true;
    }

    protected void loadBuffer(AbstractMRReply msg) {
        msg.setElement(0, this.buffer[0]);
        msg.setElement(1, this.buffer[1]);
        msg.setElement(2, this.buffer[2]);
        msg.setElement(3, this.buffer[3]);
    }

    @Override
    protected void waitForStartOfReply(DataInputStream istream) throws IOException {
    }

    @Override
    protected int addHeaderToOutput(byte[] msg, AbstractMRMessage m) {
        return 0;
    }

    @Override
    protected void addTrailerToOutput(byte[] msg, int offset, AbstractMRMessage m) {
        this.currentAddr = ((SerialMessage)m).getAddr();
    }

    @Override
    protected int lengthOfByteStream(AbstractMRMessage m) {
        return m.getNumDataElements();
    }
}

