/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine;

import jmri.implementation.AbstractTurnout;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialAddress;
import jmri.jmrix.grapevine.SerialMessage;
import jmri.jmrix.grapevine.SerialNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTurnout
extends AbstractTurnout {
    GrapevineSystemConnectionMemo memo = null;
    String tSystemName;
    int output;
    int bank;
    private static final Logger log = LoggerFactory.getLogger(SerialTurnout.class);

    public SerialTurnout(String systemName, String userName, GrapevineSystemConnectionMemo _memo) {
        super(systemName, userName);
        this.memo = _memo;
        this.tSystemName = systemName;
        int num = SerialAddress.getBitFromSystemName(systemName, this.memo.getSystemPrefix());
        log.debug("SerialTurnout {} created, num: {} prefix: {}", new Object[]{systemName, num, this.memo.getSystemPrefix()});
        this.output = num % 100 - 1;
        this.bank = num / 100 - 1;
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        try {
            this.sendMessage(this.stateChangeCheck(newState));
        }
        catch (IllegalArgumentException ex) {
            log.error("new state invalid, Turnout not set");
        }
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        log.debug("Send command to {} Pushbutton", (Object)(_pushButtonLockout ? "Lock" : "Unlock"));
    }

    protected void sendMessage(boolean closed) {
        SerialNode tNode = SerialAddress.getNodeFromSystemName(this.tSystemName, this.memo.getTrafficController());
        if (tNode == null) {
            log.error("Can't find node for {}, command ignored", (Object)this.tSystemName);
            return;
        }
        boolean high = this.output >= 12;
        int tOut = this.output;
        if (high) {
            tOut = this.output - 12;
        }
        if (this.bank < 0 || this.bank > 4) {
            log.error("invalid bank {}  for Turnout {}", (Object)this.bank, (Object)this.getSystemName());
            this.bank = 0;
        }
        SerialMessage m = new SerialMessage(high ? 8 : 4);
        int i = 0;
        if (high) {
            m.setElement(i++, tNode.getNodeAddress() | 0x80);
            m.setElement(i++, 122);
            m.setElement(i++, tNode.getNodeAddress() | 0x80);
            m.setElement(i++, 16);
            m.setParity(i - 4);
        }
        m.setElement(i++, tNode.getNodeAddress() | 0x80);
        m.setElement(i++, tOut << 3 | (closed ? 0 : 6));
        m.setElement(i++, tNode.getNodeAddress() | 0x80);
        m.setElement(i++, this.bank << 4);
        m.setParity(i - 4);
        this.memo.getTrafficController().sendSerialMessage(m, null);
    }
}

