/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.Turnout;
import jmri.jmrix.grapevine.Bundle;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialAddress;
import jmri.jmrix.grapevine.SerialTurnout;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTurnoutManager
extends AbstractTurnoutManager {
    private int nCard = 0;
    private int bitNum = 0;
    private int nNode = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialTurnoutManager.class);

    public SerialTurnoutManager(GrapevineSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public GrapevineSystemConnectionMemo getMemo() {
        return (GrapevineSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String prefix = this.getSystemPrefix();
        String sName = SerialAddress.normalizeSystemName(systemName, prefix);
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("Cannot create System Name from " + systemName);
        }
        Turnout t = (Turnout)this.getBySystemName(sName);
        if (t != null) {
            return t;
        }
        String altName = SerialAddress.convertSystemNameToAlternate(sName, prefix);
        t = (Turnout)this.getBySystemName(altName);
        if (t != null) {
            return t;
        }
        t = new SerialTurnout(sName, userName, this.getMemo());
        if (!SerialAddress.validSystemNameConfig(sName, 'T', this.getMemo().getTrafficController())) {
            log.warn("Turnout '{}' refers to an undefined Serial Node.", (Object)sName);
        }
        log.debug("new turnout {} for prefix {}", (Object)systemName, (Object)prefix);
        return t;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return false;
    }

    @Override
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        String tmpSName = prefix + "T" + curAddress;
        if (curAddress.contains(":")) {
            int separator = curAddress.indexOf(":");
            try {
                this.nNode = Integer.parseInt(curAddress.substring(0, separator));
                int nxSeparator = curAddress.indexOf(":", separator + 1);
                if (nxSeparator == -1) {
                    this.bitNum = Integer.parseInt(curAddress.substring(separator + 1));
                } else {
                    this.nCard = Integer.parseInt(curAddress.substring(separator + 1, nxSeparator)) * 100;
                    this.bitNum = Integer.parseInt(curAddress.substring(nxSeparator + 1));
                }
            }
            catch (NumberFormatException ex) {
                log.error("Unable to convert {} Hardware Address to a number", (Object)curAddress);
                throw new JmriException("Hardware Address passed should be a number");
            }
            tmpSName = prefix + "T" + this.nNode + (this.nCard + this.bitNum);
        } else {
            this.bitNum = SerialAddress.getBitFromSystemName(tmpSName, prefix);
            this.nNode = SerialAddress.getNodeAddressFromSystemName(tmpSName, prefix);
            tmpSName = prefix + "T" + this.nNode + this.bitNum;
            log.debug("createSystemName {}", (Object)tmpSName);
        }
        return tmpSName;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return SerialAddress.validateSystemNameFormat(name, this, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return SerialAddress.validSystemNameFormat(systemName, this.typeLetter(), this.getSystemPrefix());
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

