/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine.nodetable;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialMessage;
import jmri.jmrix.grapevine.nodetable.Bundle;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenumberFrame
extends JmriJFrame {
    private GrapevineSystemConnectionMemo memo = null;
    JSpinner fromSpinner;
    JSpinner toSpinner;
    JButton renumberButton;
    private static final Logger log = LoggerFactory.getLogger(RenumberFrame.class);

    public RenumberFrame(GrapevineSystemConnectionMemo _memo) {
        this.memo = _memo;
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("WindowTitleRenumber"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        contentPane.add(p);
        p.add(new JLabel(Bundle.getMessage("LabelFrom")));
        this.fromSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 127, 1));
        p.add(this.fromSpinner);
        this.fromSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RenumberFrame.this.numberSet();
            }
        });
        p.add(new JLabel(Bundle.getMessage("LabelTo")));
        this.toSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 127, 1));
        p.add(this.toSpinner);
        this.toSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RenumberFrame.this.numberSet();
            }
        });
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        contentPane.add(p);
        this.renumberButton = new JButton(Bundle.getMessage("ButtonExec"));
        p.add(this.renumberButton);
        this.renumberButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RenumberFrame.this.execute();
            }
        });
        this.renumberButton.setEnabled(false);
        this.addHelpMenu("package.jmri.jmrix.grapevine.nodetable.RenumberFrame", true);
        this.pack();
    }

    void execute() {
        int t;
        int f = (Integer)this.fromSpinner.getValue();
        if (f >= (t = ((Integer)this.toSpinner.getValue()).intValue())) {
            return;
        }
        SerialMessage m = new SerialMessage();
        m.setElement(0, 128 + (f & 0x7F));
        m.setElement(1, t & 0x7F);
        m.setElement(2, 128 + (f & 0x7F));
        m.setElement(3, 96);
        m.setParity();
        this.memo.getTrafficController().sendSerialMessage(m, null);
        log.debug("RenumberFrame sent {}", (Object)96);
    }

    void numberSet() {
        int t;
        int f = (Integer)this.fromSpinner.getValue();
        if (f == (t = ((Integer)this.toSpinner.getValue()).intValue())) {
            this.renumberButton.setEnabled(false);
        } else {
            this.renumberButton.setEnabled(true);
        }
    }
}

