/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine.packetgen;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialListener;
import jmri.jmrix.grapevine.SerialMessage;
import jmri.jmrix.grapevine.SerialReply;
import jmri.jmrix.grapevine.packetgen.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialPacketGenFrame
extends JmriJFrame
implements SerialListener {
    private GrapevineSystemConnectionMemo memo = null;
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(12);
    JButton parityButton = new JButton(Bundle.getMessage("ButtonSetParity"));
    JButton pollButton = new JButton(Bundle.getMessage("ButtonQueryNode"));
    protected JSpinner nodeAddrSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
    private static final Logger log = LoggerFactory.getLogger(SerialPacketGenFrame.class);

    public SerialPacketGenFrame(GrapevineSystemConnectionMemo _memo) {
        this.memo = _memo;
    }

    @Override
    public void initComponents() {
        this.jLabel1.setText(Bundle.getMessage("CommandLabel"));
        this.jLabel1.setVisible(true);
        this.sendButton.setText(Bundle.getMessage("ButtonSend"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("TooltipSendPacket"));
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText(Bundle.getMessage("EnterHexToolTip"));
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.setTitle(Bundle.getMessage("SendXCommandTitle", Bundle.getMessage("MenuSystem")));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.jLabel1);
        this.getContentPane().add(this.packetTextField);
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        p1.add(this.parityButton);
        p1.add(this.sendButton);
        this.getContentPane().add(p1);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerialPacketGenFrame.this.sendButtonActionPerformed(e);
            }
        });
        this.parityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerialPacketGenFrame.this.parityButtonActionPerformed(e);
            }
        });
        this.getContentPane().add(new JSeparator(0));
        JPanel pane3 = new JPanel();
        pane3.setLayout(new FlowLayout());
        pane3.add(new JLabel(Bundle.getMessage("LabelNodeAddress")));
        pane3.add(this.nodeAddrSpinner);
        this.nodeAddrSpinner.setToolTipText(Bundle.getMessage("TooltipNodeAddress"));
        pane3.add(this.pollButton);
        this.getContentPane().add(pane3);
        this.pollButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerialPacketGenFrame.this.pollButtonActionPerformed(e);
            }
        });
        this.pollButton.setToolTipText(Bundle.getMessage("PollToolTip"));
        this.addHelpMenu("package.jmri.jmrix.grapevine.packetgen.SerialPacketGenFrame", true);
        this.pack();
    }

    public void pollButtonActionPerformed(ActionEvent e) {
        SerialMessage msg = SerialMessage.getPoll((Integer)this.nodeAddrSpinner.getValue());
        this.memo.getTrafficController().sendSerialMessage(msg, this);
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        this.memo.getTrafficController().sendSerialMessage(this.createPacket(input), this);
    }

    public void parityButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        SerialMessage m = this.createPacket(input);
        if (m == null) {
            return;
        }
        m.setParity();
        this.packetTextField.setText(m.toString());
    }

    SerialMessage createPacket(String s) {
        byte[] b = StringUtil.bytesFromHexString(s);
        if (b.length != 4) {
            log.warn("Grapevine createPacket not 4 bytes");
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorInvalidMessageLength"), Bundle.getMessage("ErrorTitle"), 0);
            return null;
        }
        SerialMessage m = new SerialMessage();
        for (int i = 0; i < b.length; ++i) {
            m.setElement(i, b[i]);
        }
        return m;
    }

    @Override
    public void message(SerialMessage m) {
    }

    @Override
    public void reply(SerialReply r) {
    }
}

