/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154;

import jmri.jmrix.AbstractMRMessage;
import jmri.util.StringUtil;

public class IEEE802154Message
extends AbstractMRMessage {
    int responseLength = -1;

    protected IEEE802154Message() {
    }

    public IEEE802154Message(int l) {
        super(l);
        this.setResponseLength(0);
        this.setBinary(true);
        this.setTimeout(5000);
    }

    public IEEE802154Message(String m, int l) {
        super(m);
        this.setBinary(true);
        this.setTimeout(5000);
        byte[] b = StringUtil.bytesFromHexString(m);
        if (b.length == 0) {
            this._nDataChars = 0;
            this._dataChars = null;
            return;
        }
        this._nDataChars = b.length;
        this._dataChars = new int[this._nDataChars];
        for (int i = 0; i < b.length; ++i) {
            this.setElement(i, b[i]);
        }
    }

    public IEEE802154Message(byte[] a, int l) {
        super(String.valueOf(a));
        this.setResponseLength(l);
        this.setBinary(true);
        this.setTimeout(5000);
    }

    public boolean checkParity() {
        int len = this.getNumDataElements();
        int chksum = 0;
        for (int loop = 0; loop < len - 1; loop += 2) {
            chksum ^= this.getElement(loop) << 8;
            chksum ^= this.getElement(loop + 1);
        }
        return (chksum & 0xFFFF) == (this.getElement(len - 2) << 8) + this.getElement(len - 1);
    }

    public void setParity() {
        int len = this.getNumDataElements();
        int chksum = 0;
        for (int loop = 0; loop < len - 1; ++loop) {
            chksum ^= this.getElement(loop) << 8;
            chksum ^= this.getElement(loop + 1);
        }
        this.setElement(len - 1, chksum & 0xFF);
        this.setElement(len - 2, (chksum & 0xFF00) >> 8);
    }

    public void setResponseLength(int l) {
        this.responseLength = l;
    }

    public int getResponseLength() {
        return this.responseLength;
    }
}

