/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.serialdriver;

import java.util.Arrays;
import jmri.jmrix.ieee802154.IEEE802154PortController;
import jmri.jmrix.ieee802154.IEEE802154SystemConnectionMemo;
import jmri.jmrix.ieee802154.serialdriver.Bundle;
import jmri.jmrix.ieee802154.serialdriver.SerialSystemConnectionMemo;
import jmri.jmrix.ieee802154.serialdriver.SerialTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDriverAdapter
extends IEEE802154PortController {
    String[] stdOption1Values = new String[]{"CM11", "CP290", "Insteon 2412S"};
    private String[] validSpeeds = new String[]{Bundle.getMessage("BaudAutomatic")};
    private int[] validSpeedValues = new int[]{9600};
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        this(new SerialSystemConnectionMemo());
    }

    protected SerialDriverAdapter(IEEE802154SystemConnectionMemo connectionMemo) {
        super(connectionMemo);
        this.manufacturerName = "IEEE 802.15.4";
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        this.setSerialPort();
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    public boolean okToSend() {
        return true;
    }

    @Override
    public void configure() {
        log.debug("configure() called.");
        SerialTrafficController tc = new SerialTrafficController();
        this.getSystemConnectionMemo().setTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().configureManagers();
        tc.connectPort(this);
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    protected void setSerialPort() {
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    public String[] validOption1() {
        return Arrays.copyOf(this.stdOption1Values, this.stdOption1Values.length);
    }

    public String option1Name() {
        return "Adapter";
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    public String[] validOption2() {
        return new String[]{""};
    }

    public String option2Name() {
        return "";
    }
}

