/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.serialdriver.configurexml;

import java.util.List;
import jmri.jmrix.configurexml.AbstractSerialConnectionConfigXml;
import jmri.jmrix.ieee802154.serialdriver.ConnectionConfig;
import jmri.jmrix.ieee802154.serialdriver.SerialDriverAdapter;
import jmri.jmrix.ieee802154.serialdriver.SerialNode;
import jmri.jmrix.ieee802154.serialdriver.SerialSystemConnectionMemo;
import jmri.jmrix.ieee802154.serialdriver.SerialTrafficController;
import jmri.util.StringUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class ConnectionConfigXml
extends AbstractSerialConnectionConfigXml {
    @Override
    protected void extendElement(Element e) {
        SerialSystemConnectionMemo scm;
        try {
            scm = (SerialSystemConnectionMemo)this.adapter.getSystemConnectionMemo();
        }
        catch (NullPointerException npe) {
            return;
        }
        SerialTrafficController stc = (SerialTrafficController)scm.getTrafficController();
        SerialNode node = (SerialNode)stc.getNode(0);
        int index = 1;
        while (node != null) {
            Element n = new Element("node");
            n.setAttribute("name", "" + node.getNodeAddress());
            e.addContent((Content)n);
            n.addContent((Content)this.makeParameter("PAN", StringUtil.hexStringFromBytes(node.getPANAddress())));
            n.addContent((Content)this.makeParameter("address", StringUtil.hexStringFromBytes(node.getUserAddress())));
            n.addContent((Content)this.makeParameter("GUID", StringUtil.hexStringFromBytes(node.getGlobalAddress())));
            node = (SerialNode)stc.getNode(index);
            ++index;
        }
    }

    protected Element makeParameter(String name, String value) {
        Element p = new Element("parameter");
        p.setAttribute("name", name);
        p.addContent(value);
        return p;
    }

    @Override
    protected void getInstance() {
        this.adapter = new SerialDriverAdapter();
    }

    @Override
    protected void getInstance(Object object) {
        this.adapter = ((ConnectionConfig)object).getAdapter();
    }

    @Override
    protected void unpackElement(Element shared, Element perNode) {
        List l = shared.getChildren("node");
        for (int i = 0; i < l.size(); ++i) {
            Element n = (Element)l.get(i);
            byte[] PAN = StringUtil.bytesFromHexString(this.findParmValue(n, "PAN"));
            byte[] address = StringUtil.bytesFromHexString(this.findParmValue(n, "address"));
            byte[] GUID2 = StringUtil.bytesFromHexString(this.findParmValue(n, "GUID"));
            SerialNode node = new SerialNode(PAN, address, GUID2);
            SerialSystemConnectionMemo scm = (SerialSystemConnectionMemo)this.adapter.getSystemConnectionMemo();
            SerialTrafficController stc = (SerialTrafficController)scm.getTrafficController();
            stc.registerNode(node);
        }
    }

    @Override
    protected void register() {
        this.register(new ConnectionConfig(this.adapter));
    }
}

