/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.swing.nodeconfig;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrix.ieee802154.IEEE802154Node;
import jmri.jmrix.ieee802154.IEEE802154TrafficController;
import jmri.jmrix.ieee802154.swing.nodeconfig.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddNodeFrame
extends JmriJFrame {
    protected JTextField nodeAddrField = new JTextField();
    protected JTextField nodeAddr64Field = new JTextField();
    protected JButton addButton = new JButton(Bundle.getMessage("ButtonAdd"));
    protected JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
    protected IEEE802154Node curNode = null;
    private IEEE802154TrafficController itc = null;
    private static final Logger log = LoggerFactory.getLogger(AddNodeFrame.class);

    public AddNodeFrame(IEEE802154TrafficController tc) {
        this.addHelpMenu("package.jmri.jmrix.ieee802154.swing.nodeconfig.AddNodeFrame", true);
        this.itc = tc;
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("AddNodeWindowTitle"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel(Bundle.getMessage("LabelNodeAddress") + " "));
        panel.add(this.nodeAddrField);
        this.nodeAddrField.setToolTipText(Bundle.getMessage("TipNodeAddress"));
        panel.add(new JLabel(Bundle.getMessage("LabelNodeAddress64") + " "));
        panel.add(this.nodeAddr64Field);
        this.nodeAddr64Field.setToolTipText(Bundle.getMessage("TipNodeAddress64"));
        this.initAddressBoxes();
        contentPane.add(panel);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new FlowLayout());
        this.addButton.setText(Bundle.getMessage("ButtonAdd"));
        this.addButton.setVisible(true);
        this.addButton.setToolTipText(Bundle.getMessage("TipAddButton"));
        this.addButton.addActionListener(e -> this.addButtonActionPerformed());
        panel4.add(this.addButton);
        panel4.add(this.cancelButton);
        this.cancelButton.setText(Bundle.getMessage("ButtonCancel"));
        this.cancelButton.setVisible(true);
        this.cancelButton.setToolTipText(Bundle.getMessage("TipCancelButton"));
        panel4.add(this.cancelButton);
        this.cancelButton.addActionListener(e -> this.cancelButtonActionPerformed());
        contentPane.add(panel4);
        this.pack();
    }

    public void addButtonActionPerformed() {
        String nodeAddress = this.readNodeAddress();
        if (nodeAddress.equals("")) {
            return;
        }
        this.curNode = (IEEE802154Node)this.itc.getNodeFromAddress(nodeAddress);
        if (this.curNode != null) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("Error1", nodeAddress), Bundle.getMessage("AddNodeErrorTitle"), 0);
            log.error("Error creating IEEE802154 Node, Node exists.");
            return;
        }
        this.curNode = this.itc.newNode();
        if (this.curNode == null) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("Error3"), Bundle.getMessage("AddNodeErrorTitle"), 0);
            log.error("Error creating IEEE802154 Node, constructor returned null");
            return;
        }
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public void cancelButtonActionPerformed() {
        this.curNode = null;
        this.addButton.setVisible(true);
        this.cancelButton.setVisible(false);
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private String readNodeAddress() {
        String addr = this.nodeAddrField.getText();
        if (addr.equals("FF FF ") || addr.equals("FF FE ") || addr.equals("")) {
            addr = this.nodeAddr64Field.getText();
        }
        return addr;
    }

    protected void initAddressBoxes() {
        this.nodeAddrField.setText("");
        this.nodeAddr64Field.setText("");
    }
}

