/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.swing.nodeconfig;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrix.ieee802154.IEEE802154Node;
import jmri.jmrix.ieee802154.IEEE802154TrafficController;
import jmri.jmrix.ieee802154.swing.nodeconfig.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;

public class EditNodeFrame
extends JmriJFrame {
    protected JTextField nodeAddrField = new JTextField();
    protected JTextField nodeAddr64Field = new JTextField();
    protected JButton editButton = new JButton(Bundle.getMessage("ButtonEdit"));
    protected JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
    protected JPanel panel = new JPanel();
    protected IEEE802154Node curNode = null;

    public EditNodeFrame(IEEE802154TrafficController tc, IEEE802154Node node) {
        this.addHelpMenu("package.jmri.jmrix.ieee802154.swing.nodeconfig.EditNodeFrame", true);
        this.curNode = node;
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("EditNodeWindowTitle"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel(Bundle.getMessage("LabelNodeAddress") + " "));
        panel.add(this.nodeAddrField);
        this.nodeAddrField.setToolTipText(Bundle.getMessage("TipNodeAddress"));
        panel.add(new JLabel(Bundle.getMessage("LabelNodeAddress64") + " "));
        panel.add(this.nodeAddr64Field);
        this.nodeAddr64Field.setToolTipText(Bundle.getMessage("TipNodeAddress64"));
        this.initAddressBoxes();
        contentPane.add(panel);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new FlowLayout());
        this.editButton.setText(Bundle.getMessage("ButtonEdit"));
        this.editButton.setVisible(true);
        this.editButton.setToolTipText(Bundle.getMessage("TipEditButton"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditNodeFrame.this.editButtonActionPerformed();
            }
        });
        panel4.add(this.editButton);
        panel4.add(this.cancelButton);
        this.cancelButton.setText(Bundle.getMessage("ButtonCancel"));
        this.cancelButton.setVisible(true);
        this.cancelButton.setToolTipText(Bundle.getMessage("TipCancelButton"));
        panel4.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditNodeFrame.this.cancelButtonActionPerformed();
            }
        });
        contentPane.add(panel4);
        this.pack();
    }

    public void editButtonActionPerformed() {
        this.curNode.setUserAddress(StringUtil.bytesFromHexString(this.nodeAddrField.getText()));
        this.curNode.setGlobalAddress(StringUtil.bytesFromHexString(this.nodeAddr64Field.getText()));
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public void cancelButtonActionPerformed() {
        this.curNode = null;
        this.editButton.setVisible(true);
        this.cancelButton.setVisible(false);
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    protected void initAddressBoxes() {
        this.nodeAddrField.setText(StringUtil.hexStringFromBytes(this.curNode.getUserAddress()));
        this.nodeAddr64Field.setText(StringUtil.hexStringFromBytes(this.curNode.getGlobalAddress()));
    }
}

