/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.swing.nodeconfig;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jmri.jmrix.ieee802154.IEEE802154Node;
import jmri.jmrix.ieee802154.IEEE802154TrafficController;
import jmri.jmrix.ieee802154.swing.nodeconfig.AddNodeFrame;
import jmri.jmrix.ieee802154.swing.nodeconfig.Bundle;
import jmri.jmrix.ieee802154.swing.nodeconfig.EditNodeFrame;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConfigFrame
extends JmriJFrame {
    protected JComboBox<String> nodeAddrField = new JComboBox();
    protected JComboBox<String> nodeAddr64Field = new JComboBox();
    protected JButton addButton = new JButton(Bundle.getMessage("ButtonAdd"));
    protected JButton editButton = new JButton(Bundle.getMessage("ButtonEdit"));
    protected JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
    protected JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
    protected JButton updateButton = new JButton(Bundle.getMessage("ButtonUpdate"));
    protected JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
    protected JLabel statusText1 = new JLabel();
    protected JLabel statusText2 = new JLabel();
    protected JLabel statusText3 = new JLabel();
    protected JPanel panel2 = new JPanel();
    protected JPanel panel2a = new JPanel();
    protected boolean changedNode = false;
    protected boolean editMode = false;
    protected IEEE802154Node curNode = null;
    protected boolean errorInStatus1 = false;
    protected boolean errorInStatus2 = false;
    protected String stdStatus1 = Bundle.getMessage("NotesStd1");
    protected String stdStatus2 = Bundle.getMessage("NotesStd2");
    protected String stdStatus3 = Bundle.getMessage("NotesStd3");
    protected String editStatus1 = Bundle.getMessage("NotesEdit1");
    protected String editStatus2 = Bundle.getMessage("NotesEdit2");
    protected String editStatus3 = Bundle.getMessage("NotesEdit3");
    private IEEE802154TrafficController itc = null;
    private static final Logger log = LoggerFactory.getLogger(NodeConfigFrame.class);

    public NodeConfigFrame(IEEE802154TrafficController tc) {
        this.addHelpMenu("package.jmri.jmrix.ieee802154.swing.nodeconfig.NodeConfigFrame", true);
        this.itc = tc;
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("WindowTitle"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this.initAddressPanel());
        contentPane.add(this.initNotesPanel());
        contentPane.add(this.initButtonPanel());
        this.pack();
    }

    protected JPanel initAddressPanel() {
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        JPanel panel11 = new JPanel();
        panel11.setLayout(new FlowLayout());
        panel11.add(new JLabel(Bundle.getMessage("LabelNodeAddress") + " "));
        panel11.add(this.nodeAddrField);
        this.nodeAddrField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.nodeSelected();
            }
        });
        this.nodeAddrField.setToolTipText(Bundle.getMessage("TipNodeAddress"));
        panel11.add(new JLabel(Bundle.getMessage("LabelNodeAddress64") + " "));
        panel11.add(this.nodeAddr64Field);
        this.nodeAddr64Field.setToolTipText(Bundle.getMessage("TipNodeAddress64"));
        this.nodeAddr64Field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.nodeAddrField.setSelectedIndex(NodeConfigFrame.this.nodeAddr64Field.getSelectedIndex());
            }
        });
        this.initAddressBoxes();
        panel1.add(panel11);
        return panel1;
    }

    protected JPanel initNotesPanel() {
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel31 = new JPanel();
        panel31.setLayout(new FlowLayout());
        this.statusText1.setText(this.stdStatus1);
        this.statusText1.setVisible(true);
        panel31.add(this.statusText1);
        JPanel panel32 = new JPanel();
        panel32.setLayout(new FlowLayout());
        this.statusText2.setText(this.stdStatus2);
        this.statusText2.setVisible(true);
        panel32.add(this.statusText2);
        JPanel panel33 = new JPanel();
        panel33.setLayout(new FlowLayout());
        this.statusText3.setText(this.stdStatus3);
        this.statusText3.setVisible(true);
        panel33.add(this.statusText3);
        panel3.add(panel31);
        panel3.add(panel32);
        panel3.add(panel33);
        Border panel3Border = BorderFactory.createEtchedBorder();
        TitledBorder panel3Titled = BorderFactory.createTitledBorder(panel3Border, Bundle.getMessage("BoxLabelNotes"));
        panel3.setBorder(panel3Titled);
        return panel3;
    }

    protected JPanel initButtonPanel() {
        JPanel panel4 = new JPanel();
        panel4.setLayout(new FlowLayout());
        this.addButton.setText(Bundle.getMessage("ButtonAdd"));
        this.addButton.setVisible(true);
        this.addButton.setToolTipText(Bundle.getMessage("TipAddButton"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.addButtonActionPerformed();
            }
        });
        panel4.add(this.addButton);
        this.editButton.setText(Bundle.getMessage("ButtonEdit"));
        this.editButton.setVisible(true);
        this.editButton.setToolTipText(Bundle.getMessage("TipEditButton"));
        panel4.add(this.editButton);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.editButtonActionPerformed();
            }
        });
        panel4.add(this.deleteButton);
        this.deleteButton.setText(Bundle.getMessage("ButtonDelete"));
        this.deleteButton.setVisible(true);
        this.deleteButton.setToolTipText(Bundle.getMessage("TipDeleteButton"));
        panel4.add(this.deleteButton);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.deleteButtonActionPerformed();
            }
        });
        panel4.add(this.doneButton);
        this.doneButton.setText(Bundle.getMessage("ButtonDone"));
        this.doneButton.setVisible(true);
        this.doneButton.setToolTipText(Bundle.getMessage("TipDoneButton"));
        panel4.add(this.doneButton);
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.doneButtonActionPerformed();
            }
        });
        panel4.add(this.updateButton);
        this.updateButton.setText(Bundle.getMessage("ButtonUpdate"));
        this.updateButton.setVisible(true);
        this.updateButton.setToolTipText(Bundle.getMessage("TipUpdateButton"));
        panel4.add(this.updateButton);
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.updateButtonActionPerformed();
            }
        });
        this.updateButton.setVisible(false);
        panel4.add(this.cancelButton);
        this.cancelButton.setText(Bundle.getMessage("ButtonCancel"));
        this.cancelButton.setVisible(true);
        this.cancelButton.setToolTipText(Bundle.getMessage("TipCancelButton"));
        panel4.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.cancelButtonActionPerformed();
            }
        });
        this.cancelButton.setVisible(false);
        return panel4;
    }

    public void addButtonActionPerformed() {
        AddNodeFrame addFrame = new AddNodeFrame(this.itc);
        try {
            ((JmriJFrame)addFrame).initComponents();
        }
        catch (Exception ex) {
            log.error("Exception initializing Frame: {}", (Object)ex.toString());
            return;
        }
        addFrame.setVisible(true);
    }

    public void editButtonActionPerformed() {
        String nodeAddress = this.readNodeAddress();
        if (nodeAddress.equals("")) {
            return;
        }
        this.curNode = (IEEE802154Node)this.itc.getNodeFromAddress(nodeAddress);
        if (this.curNode == null) {
            this.statusText1.setText(Bundle.getMessage("Error4"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        EditNodeFrame editFrame = new EditNodeFrame(this.itc, this.curNode);
        try {
            ((JmriJFrame)editFrame).initComponents();
        }
        catch (Exception ex) {
            log.error("Exception initializing Frame: {}", (Object)ex.toString());
            return;
        }
        editFrame.setVisible(true);
    }

    public void deleteButtonActionPerformed() {
        String nodeAddress = this.readNodeAddress();
        if (nodeAddress.equals("")) {
            return;
        }
        this.curNode = (IEEE802154Node)this.itc.getNodeFromAddress(nodeAddress);
        if (this.curNode == null) {
            this.statusText1.setText(Bundle.getMessage("Error4"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        if (0 == JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("ConfirmDelete1") + "\n" + Bundle.getMessage("ConfirmDelete2"), Bundle.getMessage("ConfirmDeleteTitle"), 2, 2)) {
            this.itc.deleteNode(nodeAddress);
            this.resetNotes();
            this.statusText1.setText(Bundle.getMessage("FeedBackDelete") + " " + nodeAddress);
            this.errorInStatus1 = true;
            this.changedNode = true;
        } else {
            this.resetNotes();
        }
        this.initAddressBoxes();
    }

    public void doneButtonActionPerformed() {
        if (this.editMode) {
            this.editMode = false;
            this.curNode = null;
            this.addButton.setVisible(true);
            this.editButton.setVisible(true);
            this.deleteButton.setVisible(true);
            this.doneButton.setVisible(true);
            this.updateButton.setVisible(false);
            this.cancelButton.setVisible(false);
        }
        if (this.changedNode) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("Reminder1") + "\n" + Bundle.getMessage("Reminder2"), Bundle.getMessage("ReminderTitle"), 1);
        }
        this.setVisible(false);
        this.dispose();
    }

    public void updateButtonActionPerformed() {
        if (!this.checkConsistency()) {
            return;
        }
        this.setNodeParameters();
        this.changedNode = true;
        this.editMode = false;
        this.curNode = null;
        this.addButton.setVisible(true);
        this.editButton.setVisible(true);
        this.deleteButton.setVisible(true);
        this.doneButton.setVisible(true);
        this.updateButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.statusText2.setText(this.stdStatus2);
        this.statusText3.setText(this.stdStatus3);
        this.statusText1.setText(Bundle.getMessage("FeedBackUpdate") + " " + this.readNodeAddress());
        this.errorInStatus1 = true;
    }

    public void cancelButtonActionPerformed() {
        this.editMode = false;
        this.curNode = null;
        this.addButton.setVisible(true);
        this.editButton.setVisible(true);
        this.deleteButton.setVisible(true);
        this.doneButton.setVisible(true);
        this.updateButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.statusText1.setText(this.stdStatus1);
        this.statusText2.setText(this.stdStatus2);
        this.statusText3.setText(this.stdStatus3);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.doneButtonActionPerformed();
        super.windowClosing(e);
    }

    protected void setNodeParameters() {
    }

    private void resetNotes() {
        if (this.errorInStatus1) {
            if (this.editMode) {
                this.statusText1.setText(this.editStatus1);
            } else {
                this.statusText1.setText(this.stdStatus1);
            }
            this.errorInStatus1 = false;
        }
        this.resetNotes2();
    }

    private void resetNotes2() {
        if (this.errorInStatus2) {
            if (this.editMode) {
                this.statusText1.setText(this.editStatus2);
            } else {
                this.statusText2.setText(this.stdStatus2);
            }
            this.errorInStatus2 = false;
        }
    }

    private String readNodeAddress() {
        String addr = "";
        addr = (String)this.nodeAddrField.getSelectedItem();
        if (addr.equals("FF FF ") || addr.equals("FF FE ")) {
            addr = (String)this.nodeAddr64Field.getSelectedItem();
        }
        return addr;
    }

    protected boolean checkConsistency() {
        return true;
    }

    protected void initAddressBoxes() {
        IEEE802154Node current = null;
        this.nodeAddrField.removeAllItems();
        this.nodeAddr64Field.removeAllItems();
        for (int i = 0; i < this.itc.getNumNodes(); ++i) {
            current = (IEEE802154Node)this.itc.getNode(i);
            this.nodeAddrField.insertItemAt(StringUtil.hexStringFromBytes(current.getUserAddress()), i);
            this.nodeAddr64Field.insertItemAt(StringUtil.hexStringFromBytes(current.getGlobalAddress()), i);
        }
        this.nodeAddrField.insertItemAt("", 0);
        this.nodeAddrField.setEditable(true);
        this.nodeAddr64Field.insertItemAt("", 0);
    }

    protected void nodeSelected() {
        this.nodeAddr64Field.setSelectedIndex(this.nodeAddrField.getSelectedIndex());
    }
}

