/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.connection.ConnectionType;
import com.digi.xbee.api.connection.IConnectionInterface;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Arrays;
import jmri.jmrix.SerialPortDataListener;
import jmri.jmrix.SerialPortEvent;
import jmri.jmrix.ieee802154.IEEE802154SystemConnectionMemo;
import jmri.jmrix.ieee802154.serialdriver.SerialDriverAdapter;
import jmri.jmrix.ieee802154.xbee.Bundle;
import jmri.jmrix.ieee802154.xbee.XBeeConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeAdapter
extends SerialDriverAdapter
implements IConnectionInterface,
SerialPortDataListener {
    private boolean iConnectionOpened = false;
    private final String[] validSpeeds = new String[]{Bundle.getMessage("Baud1200"), Bundle.getMessage("Baud2400"), Bundle.getMessage("Baud4800"), Bundle.getMessage("Baud9600"), Bundle.getMessage("Baud19200"), Bundle.getMessage("Baud38400"), Bundle.getMessage("Baud57600"), Bundle.getMessage("Baud115200")};
    private final int[] validSpeedValues = new int[]{1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200};
    private static final Logger log = LoggerFactory.getLogger(XBeeAdapter.class);

    public XBeeAdapter() {
        super(new XBeeConnectionMemo());
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        this.setSerialPort();
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    protected void setSerialPort() {
        log.debug("setSerialPort() called.");
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setDataListener(this.currentSerialPort, this);
    }

    @Override
    public void configure() {
        log.debug("configure() called.");
        XBeeTrafficController tc = new XBeeTrafficController();
        this.getSystemConnectionMemo().setTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        tc.connectPort(this);
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public XBeeConnectionMemo getSystemConnectionMemo() {
        IEEE802154SystemConnectionMemo m = super.getSystemConnectionMemo();
        if (m instanceof XBeeConnectionMemo) {
            return (XBeeConnectionMemo)m;
        }
        throw new IllegalArgumentException("System Connection Memo associated with this connection is not the right type.");
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    public void close() {
        this.closeSerialPort(this.currentSerialPort);
        this.iConnectionOpened = false;
    }

    public int readData(byte[] b) throws IOException {
        log.debug("read data called with {}", (Object)b);
        return ((DataInputStream)this.getInputStream()).read(b);
    }

    public int readData(byte[] b, int off, int len) throws IOException {
        log.debug("read data called with {} {} {}", new Object[]{b, off, len});
        return ((DataInputStream)this.getInputStream()).read(b, off, len);
    }

    public void writeData(byte[] b) throws IOException {
        log.debug("write data called with {}", (Object)b);
        ((FilterOutputStream)this.getOutputStream()).write(b);
    }

    public void writeData(byte[] b, int off, int len) throws IOException {
        log.debug("write data called with {} {} {}", new Object[]{b, off, len});
        ((DataOutputStream)this.getOutputStream()).write(b, off, len);
    }

    public boolean isOpen() {
        log.debug("isOpen called");
        return this.iConnectionOpened;
    }

    public void open() {
        log.debug("open called");
        this.iConnectionOpened = true;
    }

    public ConnectionType getConnectionType() {
        return ConnectionType.UNKNOWN;
    }

    @Override
    public int getListeningEvents() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="The notify call is notifying the receive thread that data is available due to an event.")
    public void serialEvent(SerialPortEvent serialPortEvent) {
        if (serialPortEvent.getEventType() != 1) {
            return;
        }
        XBeeAdapter xBeeAdapter = this;
        synchronized (xBeeAdapter) {
            this.notifyAll();
        }
    }
}

