/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import java.util.ResourceBundle;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.jmrix.ieee802154.IEEE802154SystemConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeLightManager;
import jmri.jmrix.ieee802154.xbee.XBeeNodeManager;
import jmri.jmrix.ieee802154.xbee.XBeeSensorManager;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import jmri.jmrix.ieee802154.xbee.XBeeTurnoutManager;
import jmri.jmrix.ieee802154.xbee.swing.XBeeComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeConnectionMemo
extends IEEE802154SystemConnectionMemo {
    ComponentFactory componentFactory = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeConnectionMemo.class);

    public XBeeConnectionMemo() {
        super("Z", "XBee");
        InstanceManager.store(this, XBeeConnectionMemo.class);
    }

    @Override
    protected void init() {
        this.componentFactory = new XBeeComponentFactory(this);
        InstanceManager.store(this.componentFactory, ComponentFactory.class);
    }

    @Override
    public void configureManagers() {
        log.debug("Configuring Managers for XBee Connection");
        XBeeTrafficController cont = (XBeeTrafficController)this.getTrafficController();
        this.setXBeeNodeManager(new XBeeNodeManager(cont));
        this.setSensorManager(new XBeeSensorManager(this));
        InstanceManager.setSensorManager(this.getSensorManager());
        this.setLightManager(new XBeeLightManager(this));
        InstanceManager.setLightManager(this.getLightManager());
        this.setTurnoutManager(new XBeeTurnoutManager(this));
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        this.register();
    }

    public XBeeNodeManager getXBeeNodeManager() {
        return this.get(XBeeNodeManager.class);
    }

    public void setXBeeNodeManager(XBeeNodeManager manager) {
        this.store(manager, XBeeNodeManager.class);
    }

    public SensorManager getSensorManager() {
        return this.get(SensorManager.class);
    }

    public void setSensorManager(SensorManager s) {
        this.store(s, SensorManager.class);
    }

    public LightManager getLightManager() {
        return this.get(LightManager.class);
    }

    public void setLightManager(LightManager s) {
        this.store(s, LightManager.class);
    }

    public TurnoutManager getTurnoutManager() {
        return this.get(TurnoutManager.class);
    }

    public void setTurnoutManager(TurnoutManager s) {
        this.store(s, TurnoutManager.class);
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.ieee802154.IEEE802154ActionListBundle");
    }

    @Override
    public void dispose() {
        InstanceManager.deregister(this, XBeeConnectionMemo.class);
        super.dispose();
    }
}

