/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.io.IOLine;
import com.digi.xbee.api.io.IOValue;
import jmri.implementation.AbstractLight;
import jmri.jmrix.ieee802154.IEEE802154SystemConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeLight
extends AbstractLight {
    private String nodeIdentifier;
    private XBeeNode node = null;
    private int pin;
    protected XBeeTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeLight.class);

    public XBeeLight(String systemName, String userName, XBeeTrafficController controller) {
        super(systemName, userName);
        this.tc = controller;
        this.init(systemName);
    }

    public XBeeLight(String systemName, XBeeTrafficController controller) {
        super(systemName);
        this.tc = controller;
        this.init(systemName);
    }

    private void init(String id) {
        IEEE802154SystemConnectionMemo m = this.tc.getAdapterMemo();
        if (!(m instanceof XBeeConnectionMemo)) {
            log.error("Memo associated with the traffic controller is not the right type");
            throw new IllegalArgumentException("Memo associated with the traffic controller is not the right type");
        }
        XBeeConnectionMemo memo = (XBeeConnectionMemo)m;
        String prefix = memo.getLightManager().getSystemPrefix();
        if (id.contains(":")) {
            int seperator = id.indexOf(":");
            try {
                this.nodeIdentifier = id.substring(prefix.length() + 1, seperator);
                this.node = (XBeeNode)this.tc.getNodeFromName(this.nodeIdentifier);
                if (this.node == null && (this.node = (XBeeNode)this.tc.getNodeFromAddress(this.nodeIdentifier)) == null) {
                    try {
                        this.node = (XBeeNode)this.tc.getNodeFromAddress(Integer.parseInt(this.nodeIdentifier));
                    }
                    catch (NumberFormatException nfe) {
                        this.node = null;
                    }
                }
                this.pin = Integer.parseInt(id.substring(seperator + 1));
            }
            catch (NumberFormatException ex) {
                log.debug("Unable to convert {} into the cab and input format of nn:xx", (Object)id);
            }
        } else {
            try {
                this.nodeIdentifier = id.substring(prefix.length() + 1, id.length() - 1);
                int address = Integer.parseInt(id.substring(prefix.length() + 1));
                this.node = (XBeeNode)this.tc.getNodeFromAddress(address / 10);
                this.pin = address % 10;
            }
            catch (NumberFormatException ex) {
                log.debug("Unable to convert {} Hardware Address to a number", (Object)id);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Created Light {} (NodeIdentifier {} D{})", new Object[]{id, this.nodeIdentifier, this.pin});
        }
    }

    @Override
    protected void doNewState(int oldState, int newState) {
        try {
            if (newState == 2) {
                this.node.getXBee().setDIOValue(IOLine.getDIO((int)this.pin), IOValue.HIGH);
            } else {
                this.node.getXBee().setDIOValue(IOLine.getDIO((int)this.pin), IOValue.LOW);
            }
        }
        catch (TimeoutException toe) {
            log.error("Timeout setting IO line value for light {} on {}", (Object)this.getUserName(), (Object)this.node.getXBee());
        }
        catch (InterfaceNotOpenException ino) {
            log.error("Interface Not Open setting IO line value for light {} on {}", (Object)this.getUserName(), (Object)this.node.getXBee());
        }
        catch (XBeeException xbe) {
            log.error("Error setting IO line value for light {} on {}", (Object)this.getUserName(), (Object)this.node.getXBee());
        }
    }
}

