/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.packet.common.ATCommandPacket;
import com.digi.xbee.api.packet.common.RemoteATCommandPacket;
import com.digi.xbee.api.packet.common.TransmitPacket;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import jmri.jmrix.ieee802154.IEEE802154Message;
import jmri.util.StringUtil;

public class XBeeMessage
extends IEEE802154Message {
    private XBeeAPIPacket xbm = null;

    protected XBeeMessage() {
    }

    public XBeeMessage(int l) {
        super(l);
    }

    public XBeeMessage(String m, int l) {
        super(m, l);
    }

    public XBeeMessage(byte[] a, int l) {
        super(Arrays.toString(a), l);
    }

    public XBeeMessage(XBeeAPIPacket request) {
        this._nDataChars = request.getPacketData().length;
        byte[] data = request.getPacketData();
        this._dataChars = new int[this._nDataChars];
        for (int i = 0; i < this._nDataChars; ++i) {
            this._dataChars[i] = data[i];
        }
        this.xbm = request;
    }

    @Override
    public boolean replyExpected() {
        return false;
    }

    public XBeeAPIPacket getXBeeRequest() {
        return this.xbm;
    }

    public void setXBeeRequest(XBeeAPIPacket request) {
        this.xbm = request;
    }

    @Override
    public String toMonitorString() {
        if (this.xbm != null) {
            return this.xbm.toPrettyString();
        }
        return this.toString();
    }

    @Override
    public String toString() {
        String s = "";
        if (this.xbm != null) {
            byte[] packet;
            for (byte b : packet = this.xbm.getPacketData()) {
                s = StringUtil.appendTwoHexFromInt(b, s);
            }
        }
        return s;
    }

    @Override
    public boolean checkParity() {
        int len = this.getNumDataElements();
        int chksum = 0;
        for (int loop = 0; loop < len - 1; ++loop) {
            chksum ^= this.getElement(loop);
        }
        return (chksum & 0xFF) == this.getElement(len - 1);
    }

    @Override
    public void setParity() {
        int len = this.getNumDataElements();
        int chksum = 0;
        for (int loop = 0; loop < len - 1; ++loop) {
            chksum ^= this.getElement(loop);
        }
        this.setElement(len - 1, chksum & 0xFF);
    }

    public static XBeeMessage getHardwareVersionRequest() {
        return new XBeeMessage((XBeeAPIPacket)new ATCommandPacket(0, "HV", ""));
    }

    public static XBeeMessage getFirmwareVersionRequest() {
        return new XBeeMessage((XBeeAPIPacket)new ATCommandPacket(0, "VR", ""));
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The passed address must be either a 16 bit address or a 64 bit address, and we check to see if the address is a 16 bit address, so it is redundant to also check for a 64 bit address")
    public static XBeeMessage getRemoteDoutMessage(Object address, int pin, boolean on) {
        byte[] onValue = new byte[]{5};
        byte[] offValue = new byte[]{4};
        if (address instanceof XBee16BitAddress) {
            return new XBeeMessage((XBeeAPIPacket)new RemoteATCommandPacket(9999, XBee64BitAddress.COORDINATOR_ADDRESS, (XBee16BitAddress)address, 0, "D" + pin, on ? onValue : offValue));
        }
        return new XBeeMessage((XBeeAPIPacket)new RemoteATCommandPacket(9999, (XBee64BitAddress)address, XBee16BitAddress.UNKNOWN_ADDRESS, 0, "D" + pin, on ? onValue : offValue));
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The passed address must be either a 16 bit address or a 64 bit address, and we check to see if the address is a 16 bit address, so it is redundant to also check for a 64 bit address")
    public static XBeeMessage getRemoteDoutMessage(Object address, int pin) {
        if (address instanceof XBee16BitAddress) {
            return new XBeeMessage((XBeeAPIPacket)new RemoteATCommandPacket(9999, XBee64BitAddress.COORDINATOR_ADDRESS, (XBee16BitAddress)address, 0, "D" + pin, ""));
        }
        return new XBeeMessage((XBeeAPIPacket)new RemoteATCommandPacket(9999, (XBee64BitAddress)address, XBee16BitAddress.UNKNOWN_ADDRESS, 0, "D" + pin, ""));
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The passed address must be either a 16 bit address or a 64 bit address, and we check to see if the address is a 16 bit address, so it is redundant to also check for a 64 bit address")
    public static XBeeMessage getForceSampleMessage(Object address) {
        if (address instanceof XBee16BitAddress) {
            return new XBeeMessage((XBeeAPIPacket)new RemoteATCommandPacket(9999, XBee64BitAddress.COORDINATOR_ADDRESS, (XBee16BitAddress)address, 0, "IS", ""));
        }
        return new XBeeMessage((XBeeAPIPacket)new RemoteATCommandPacket(9999, (XBee64BitAddress)address, XBee16BitAddress.UNKNOWN_ADDRESS, 0, "IS", ""));
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The passed address must be either a 16 bit address or a 64 bit address, and we check to see if the address is a 16 bit address, so it is redundant to also check for a 64 bit address")
    public static XBeeMessage getRemoteTransmissionRequest(Object address, byte[] payload) {
        if (address instanceof XBee16BitAddress) {
            return XBeeMessage.getRemoteTransmissionRequest((XBee16BitAddress)address, payload);
        }
        return XBeeMessage.getRemoteTransmissionRequest((XBee64BitAddress)address, payload);
    }

    public static XBeeMessage getRemoteTransmissionRequest(XBee16BitAddress address, byte[] payload) {
        return new XBeeMessage((XBeeAPIPacket)new TransmitPacket(9999, XBee64BitAddress.COORDINATOR_ADDRESS, address, 255, 0, payload));
    }

    public static XBeeMessage getRemoteTransmissionRequest(XBee64BitAddress address, byte[] payload) {
        return new XBeeMessage((XBeeAPIPacket)new TransmitPacket(9999, address, XBee16BitAddress.UNKNOWN_ADDRESS, 255, 0, payload));
    }
}

