/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.AbstractXBeeDevice;
import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractStreamConnectionConfig;
import jmri.jmrix.AbstractStreamPortController;
import jmri.jmrix.ieee802154.IEEE802154Node;
import jmri.jmrix.ieee802154.xbee.XBeeIOStream;
import jmri.jmrix.ieee802154.xbee.XBeeSensor;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeNode
extends IEEE802154Node {
    private String identifier;
    private HashMap<Integer, NamedBean> pinObjects = null;
    private boolean isPolled;
    private XBeeTrafficController tc = null;
    private RemoteXBeeDevice device = null;
    private XBee16BitAddress userAddress = null;
    private XBee64BitAddress globalAddress = null;
    private static final byte[] DefaultPanID = new byte[]{0, 0};
    private XBeeIOStream mStream = null;
    private AbstractStreamPortController connectedController = null;
    private AbstractStreamConnectionConfig connectedConfig = null;
    private byte[] PRValue = null;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private static final Logger log = LoggerFactory.getLogger(XBeeNode.class);

    public XBeeNode() {
        this.identifier = "";
        this.pinObjects = new HashMap();
        this.isPolled = false;
    }

    public XBeeNode(byte[] pan, byte[] user, byte[] global) {
        super(pan, user, global);
        this.identifier = "";
        log.debug("Created new node with panId: {} userId: {} and GUID: {}", new Object[]{StringUtil.arrayToString(pan), StringUtil.arrayToString(user), StringUtil.arrayToString(global)});
        this.pinObjects = new HashMap();
        this.isPolled = false;
        this.userAddress = new XBee16BitAddress(user);
        this.globalAddress = new XBee64BitAddress(global);
    }

    public XBeeNode(RemoteXBeeDevice rxd) throws XBeeException {
        super(DefaultPanID, rxd.get16BitAddress().getValue(), rxd.get64BitAddress().getValue());
        this.identifier = rxd.getNodeID();
        try {
            this.setPANAddress(rxd.getPANID());
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        log.debug("Created new node from RemoteXBeeDevice: {}", (Object)rxd);
        this.pinObjects = new HashMap();
        this.isPolled = false;
        this.device = rxd;
        this.userAddress = this.device.get16BitAddress();
        this.globalAddress = this.device.get64BitAddress();
    }

    public void setTrafficController(XBeeTrafficController controller) {
        this.tc = controller;
    }

    @Override
    public AbstractMRMessage createInitPacket() {
        return null;
    }

    @Override
    public AbstractMRMessage createOutPacket() {
        return null;
    }

    @Override
    public boolean getSensorsActive() {
        if (this.getPoll()) {
            for (NamedBean bean : this.pinObjects.values()) {
                if (!(bean instanceof XBeeSensor)) continue;
                return true;
            }
        }
        return false;
    }

    public void setPoll(boolean poll) {
        this.isPolled = poll;
    }

    public boolean getPoll() {
        return this.isPolled;
    }

    @Override
    public boolean handleTimeout(AbstractMRMessage m, AbstractMRListener l) {
        return false;
    }

    @Override
    public void resetTimeout(AbstractMRMessage m) {
    }

    public XBee16BitAddress getXBeeAddress16() {
        if (this.device != null) {
            return this.device.get16BitAddress();
        }
        return this.userAddress;
    }

    public XBee64BitAddress getXBeeAddress64() {
        if (this.device != null) {
            return this.device.get64BitAddress();
        }
        return this.globalAddress;
    }

    public void setIdentifier(String id) {
        try {
            this.device.setNodeID(id);
        }
        catch (XBeeException xBeeException) {
            // empty catch block
        }
    }

    public String getIdentifier() {
        return this.device.getNodeID();
    }

    public boolean setPinBean(int pin, NamedBean bean) {
        if (this.pinObjects.containsKey(pin)) {
            log.error("Pin {} already Assigned to object {}", (Object)pin, (Object)this.pinObjects.get(pin));
            return false;
        }
        this.pinObjects.put(pin, bean);
        return true;
    }

    public boolean removePinBean(int pin, NamedBean bean) {
        if (bean == this.getPinBean(pin)) {
            this.pinObjects.remove(pin);
            return true;
        }
        return false;
    }

    public NamedBean getPinBean(int pin) {
        return this.pinObjects.get(pin);
    }

    public boolean getPinAssigned(int pin) {
        return this.pinObjects.containsKey(pin);
    }

    public String getPreferedName() {
        if (!this.identifier.equals("")) {
            return this.identifier;
        }
        if (!this.getXBeeAddress16().equals((Object)XBee16BitAddress.BROADCAST_ADDRESS) && !this.getXBeeAddress16().equals((Object)XBee16BitAddress.UNKNOWN_ADDRESS)) {
            return StringUtil.hexStringFromBytes(this.useraddress);
        }
        return StringUtil.hexStringFromBytes(this.globaladdress);
    }

    public Object getPreferedTransmitAddress() {
        if (!this.getXBeeAddress16().equals((Object)XBee16BitAddress.BROADCAST_ADDRESS) && !this.getXBeeAddress16().equals((Object)XBee16BitAddress.UNKNOWN_ADDRESS)) {
            return this.getXBeeAddress16();
        }
        return this.getXBeeAddress64();
    }

    public RemoteXBeeDevice getXBee() {
        if (this.device == null && this.tc != null) {
            this.device = new RemoteXBeeDevice((AbstractXBeeDevice)this.tc.getXBee(), this.globalAddress, this.userAddress, this.identifier);
        }
        return this.device;
    }

    public void setXBee(RemoteXBeeDevice rxd) {
        this.device = rxd;
        this.userAddress = this.device.get16BitAddress();
        this.globalAddress = this.device.get64BitAddress();
        this.setUserAddress(rxd.get16BitAddress().getValue());
        this.setGlobalAddress(rxd.get64BitAddress().getValue());
        this.identifier = rxd.getNodeID();
    }

    public XBeeIOStream getIOStream() {
        if (this.mStream == null) {
            this.mStream = new XBeeIOStream(this, this.tc);
            this.mStream.configure();
        }
        return this.mStream;
    }

    public void connectPortController(AbstractStreamPortController cont) {
        this.connectedController = cont;
        this.connectedController.configure();
    }

    public void setPortController(AbstractStreamPortController cont) {
        this.connectedController = cont;
    }

    public AbstractStreamPortController getPortController() {
        return this.connectedController;
    }

    public void connectPortController(AbstractStreamConnectionConfig cfg) {
        this.connectedConfig = cfg;
        this.connectPortController(cfg.getAdapter());
    }

    public void setPortController(AbstractStreamConnectionConfig cfg) {
        this.connectedConfig = cfg;
        this.setPortController(cfg.getAdapter());
    }

    public AbstractStreamConnectionConfig getConnectionConfig() {
        return this.connectedConfig;
    }

    public String toString() {
        return "(" + StringUtil.hexStringFromBytes(this.getUserAddress()) + "," + StringUtil.hexStringFromBytes(this.getGlobalAddress()) + "," + this.getIdentifier() + ")";
    }

    void setPRParameter(int pin, Sensor.PullResistance pr) throws TimeoutException, XBeeException {
        if (pin > 7 || pin < 0) {
            throw new IllegalArgumentException("Invalid pin specified");
        }
        try {
            this.writeLock.lock();
            this.PRValue = this.device.getParameter("PR");
            switch (pin) {
                case 0: {
                    if (pr == Sensor.PullResistance.PULL_UP) {
                        this.PRValue[0] = (byte)(this.PRValue[0] | 1);
                        break;
                    }
                    this.PRValue[0] = (byte)(this.PRValue[0] & 0xFE);
                    break;
                }
                case 1: {
                    if (pr == Sensor.PullResistance.PULL_UP) {
                        this.PRValue[0] = (byte)(this.PRValue[0] | 2);
                        break;
                    }
                    this.PRValue[0] = (byte)(this.PRValue[0] & 0xFD);
                    break;
                }
                case 2: {
                    if (pr == Sensor.PullResistance.PULL_UP) {
                        this.PRValue[0] = (byte)(this.PRValue[0] | 4);
                        break;
                    }
                    this.PRValue[0] = (byte)(this.PRValue[0] & 0xFB);
                    break;
                }
                case 3: {
                    if (pr == Sensor.PullResistance.PULL_UP) {
                        this.PRValue[0] = (byte)(this.PRValue[0] | 8);
                        break;
                    }
                    this.PRValue[0] = (byte)(this.PRValue[0] & 0xF7);
                    break;
                }
                case 4: {
                    if (pr == Sensor.PullResistance.PULL_UP) {
                        this.PRValue[0] = (byte)(this.PRValue[0] | 0x10);
                        break;
                    }
                    this.PRValue[0] = (byte)(this.PRValue[0] & 0xEF);
                    break;
                }
                case 5: {
                    if (pr == Sensor.PullResistance.PULL_UP) {
                        this.PRValue[0] = (byte)(this.PRValue[0] | 0x20);
                        break;
                    }
                    this.PRValue[0] = (byte)(this.PRValue[0] & 0xDF);
                    break;
                }
                case 6: {
                    if (pr == Sensor.PullResistance.PULL_UP) {
                        this.PRValue[0] = (byte)(this.PRValue[0] | 0x40);
                        break;
                    }
                    this.PRValue[0] = (byte)(this.PRValue[0] & 0xBF);
                    break;
                }
                case 7: {
                    if (pr == Sensor.PullResistance.PULL_UP) {
                        this.PRValue[0] = (byte)(this.PRValue[0] | 0xFFFFFF80);
                        break;
                    }
                    this.PRValue[0] = (byte)(this.PRValue[0] & 0x7F);
                    break;
                }
                default: {
                    log.warn("Unhandled pin value: {}", (Object)pin);
                }
            }
            this.device.setParameter("PR", this.PRValue);
            this.device.applyChanges();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    Sensor.PullResistance getPRValueForPin(int pin) throws TimeoutException, XBeeException {
        byte prbyte;
        if (pin > 7 || pin < 0) {
            throw new IllegalArgumentException("Invalid pin specified");
        }
        try {
            this.readLock.lock();
            if (this.PRValue == null) {
                this.PRValue = this.device.getParameter("PR");
            }
            prbyte = this.PRValue[0];
        }
        finally {
            this.readLock.unlock();
        }
        Sensor.PullResistance retval = Sensor.PullResistance.PULL_OFF;
        switch (pin) {
            case 0: {
                if ((prbyte & 1) == 1) {
                    retval = Sensor.PullResistance.PULL_UP;
                    break;
                }
                retval = Sensor.PullResistance.PULL_OFF;
                break;
            }
            case 1: {
                if ((prbyte & 2) == 2) {
                    retval = Sensor.PullResistance.PULL_UP;
                    break;
                }
                retval = Sensor.PullResistance.PULL_OFF;
                break;
            }
            case 2: {
                if ((prbyte & 4) == 4) {
                    retval = Sensor.PullResistance.PULL_UP;
                    break;
                }
                retval = Sensor.PullResistance.PULL_OFF;
                break;
            }
            case 3: {
                if ((prbyte & 8) == 8) {
                    retval = Sensor.PullResistance.PULL_UP;
                    break;
                }
                retval = Sensor.PullResistance.PULL_OFF;
                break;
            }
            case 4: {
                if ((prbyte & 0x10) == 16) {
                    retval = Sensor.PullResistance.PULL_UP;
                    break;
                }
                retval = Sensor.PullResistance.PULL_OFF;
                break;
            }
            case 5: {
                if ((prbyte & 0x20) == 32) {
                    retval = Sensor.PullResistance.PULL_UP;
                    break;
                }
                retval = Sensor.PullResistance.PULL_OFF;
                break;
            }
            case 6: {
                if ((prbyte & 0x40) == 64) {
                    retval = Sensor.PullResistance.PULL_UP;
                    break;
                }
                retval = Sensor.PullResistance.PULL_OFF;
                break;
            }
            case 7: {
                if ((prbyte & 0x80) == 128) {
                    retval = Sensor.PullResistance.PULL_UP;
                    break;
                }
                retval = Sensor.PullResistance.PULL_OFF;
                break;
            }
            default: {
                retval = Sensor.PullResistance.PULL_OFF;
            }
        }
        return retval;
    }
}

