/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.packet.UnknownXBeePacket;
import com.digi.xbee.api.packet.XBeePacket;
import jmri.jmrix.ieee802154.IEEE802154Reply;
import jmri.util.StringUtil;

public class XBeeReply
extends IEEE802154Reply {
    XBeePacket xbresponse = null;

    public XBeeReply() {
        this.setBinary(true);
    }

    public XBeeReply(String s) {
        super(s);
        this.setBinary(true);
        byte[] ba = StringUtil.bytesFromHexString(s);
        for (int i = 0; i < ba.length; ++i) {
            this._dataChars[i] = ba[i];
        }
        this._nDataChars = ba.length;
        this.xbresponse = UnknownXBeePacket.createPacket((byte[])ba);
    }

    public XBeeReply(XBeeReply l) {
        super(l);
        this.xbresponse = l.xbresponse;
        byte[] data = this.xbresponse.getPacketData();
        for (int i = 0; i < data.length; ++i) {
            this._dataChars[i] = data[i];
        }
        this._nDataChars = data.length;
        this.setBinary(true);
    }

    public XBeeReply(XBeePacket xbr) {
        this.xbresponse = xbr;
        byte[] data = xbr.getPacketData();
        for (int i = 0; i < data.length; ++i) {
            this._dataChars[i] = data[i];
        }
        this._nDataChars = data.length;
        this.setBinary(true);
    }

    @Override
    public String toMonitorString() {
        return this.xbresponse.toPrettyString();
    }

    @Override
    public String toString() {
        return this.xbresponse.toString();
    }

    public XBeePacket getXBeeResponse() {
        return this.xbresponse;
    }

    public void setXBeeResponse(XBeePacket xbr) {
        this.xbresponse = xbr;
    }
}

