/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.io.IOLine;
import com.digi.xbee.api.io.IOSample;
import com.digi.xbee.api.io.IOValue;
import com.digi.xbee.api.listeners.IIOSampleReceiveListener;
import jmri.Sensor;
import jmri.implementation.AbstractSensor;
import jmri.jmrix.ieee802154.IEEE802154SystemConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeSensor
extends AbstractSensor
implements IIOSampleReceiveListener {
    private String nodeIdentifier;
    private int pin;
    private XBeeNode node = null;
    protected XBeeTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeSensor.class);

    public XBeeSensor(String systemName, String userName, XBeeTrafficController controller) {
        super(systemName, userName);
        this.tc = controller;
        this.init(systemName);
    }

    public XBeeSensor(String systemName, XBeeTrafficController controller) {
        super(systemName);
        this.tc = controller;
        this.init(systemName);
    }

    private void init(String id) {
        IEEE802154SystemConnectionMemo m = this.tc.getAdapterMemo();
        if (!(m instanceof XBeeConnectionMemo)) {
            log.error("Memo associated with the traffic controller is not the right type");
            throw new IllegalArgumentException("Memo associated with the traffic controller is not the right type");
        }
        XBeeConnectionMemo memo = (XBeeConnectionMemo)m;
        String prefix = memo.getSensorManager().getSystemPrefix();
        if (id.contains(":")) {
            int seperator = id.indexOf(":");
            try {
                this.nodeIdentifier = id.substring(prefix.length() + 1, seperator);
                this.node = (XBeeNode)this.tc.getNodeFromName(this.nodeIdentifier);
                if (this.node == null && (this.node = (XBeeNode)this.tc.getNodeFromAddress(this.nodeIdentifier)) == null) {
                    try {
                        this.node = (XBeeNode)this.tc.getNodeFromAddress(Integer.parseInt(this.nodeIdentifier));
                    }
                    catch (NumberFormatException nfe) {
                        this.node = null;
                    }
                }
                this.pin = Integer.parseInt(id.substring(seperator + 1));
            }
            catch (NumberFormatException ex) {
                log.debug("Unable to convert {} into the cab and input format of nn:xx", (Object)id);
            }
        } else {
            try {
                this.nodeIdentifier = id.substring(prefix.length() + 1, id.length() - 1);
                int address = Integer.parseInt(id.substring(prefix.length() + 1));
                this.node = (XBeeNode)this.tc.getNodeFromAddress(address / 10);
                this.pin = address % 10;
            }
            catch (NumberFormatException ex) {
                log.debug("Unable to convert {} Hardware Address to a number", (Object)id);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Created Sensor {} (NodeIdentifier {} ,D{})", new Object[]{id, this.nodeIdentifier, this.pin});
        }
        this.tc.getXBee().addIOSampleListener((IIOSampleReceiveListener)this);
        this.requestUpdateFromLayout();
    }

    @Override
    public void requestUpdateFromLayout() {
        try {
            IOValue value = this.node.getXBee().getDIOValue(IOLine.getDIO((int)this.pin));
            if (value == IOValue.HIGH ^ this._inverted) {
                this.setOwnState(2);
            } else {
                this.setOwnState(4);
            }
        }
        catch (TimeoutException toe) {
            log.error("Timeout retrieving IO line value for {} on {}", (Object)IOLine.getDIO((int)this.pin), (Object)this.node.getXBee());
            this.setOwnState(1);
        }
        catch (InterfaceNotOpenException ino) {
            log.error("Interface Not Open retrieving IO line value for {} on {}", (Object)IOLine.getDIO((int)this.pin), (Object)this.node.getXBee());
        }
        catch (XBeeException xbe) {
            log.error("Error retrieving IO line value for {} on {}", (Object)IOLine.getDIO((int)this.pin), (Object)this.node.getXBee());
        }
    }

    public synchronized void ioSampleReceived(RemoteXBeeDevice remoteDevice, IOSample ioSample) {
        XBeeNode sourcenode;
        if (log.isDebugEnabled()) {
            log.debug("received io sample {} from {}", (Object)ioSample, (Object)remoteDevice);
        }
        if (this.node.equals(sourcenode = (XBeeNode)this.tc.getNodeFromXBeeDevice(remoteDevice)) && ioSample.hasDigitalValues()) {
            if (ioSample.getDigitalValue(IOLine.getDIO((int)this.pin)) == IOValue.HIGH ^ this._inverted) {
                this.setOwnState(2);
            } else {
                this.setOwnState(4);
            }
        }
    }

    @Override
    public void setPullResistance(Sensor.PullResistance r) {
        try {
            this.node.setPRParameter(this.pin, r);
        }
        catch (TimeoutException toe) {
            log.error("Timeout retrieving PR value for {} on {}", (Object)IOLine.getDIO((int)this.pin), (Object)this.node.getXBee());
        }
        catch (XBeeException xbe) {
            log.error("Error retrieving PR value for {} on {}", (Object)IOLine.getDIO((int)this.pin), (Object)this.node.getXBee());
        }
    }

    @Override
    public Sensor.PullResistance getPullResistance() {
        try {
            return this.node.getPRValueForPin(this.pin);
        }
        catch (TimeoutException toe) {
            log.error("Timeout retrieving PR value for {} on {}", (Object)IOLine.getDIO((int)this.pin), (Object)this.node.getXBee());
        }
        catch (XBeeException xbe) {
            log.error("Error retrieving PR value for {} on {}", (Object)IOLine.getDIO((int)this.pin), (Object)this.node.getXBee());
        }
        return Sensor.PullResistance.PULL_UP;
    }

    @Override
    public void dispose() {
        this.tc.getXBee().removeIOSampleListener((IIOSampleReceiveListener)this);
        super.dispose();
    }
}

