/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.io.IOLine;
import com.digi.xbee.api.io.IOMode;
import com.digi.xbee.api.io.IOSample;
import com.digi.xbee.api.listeners.IIOSampleReceiveListener;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.ieee802154.xbee.Bundle;
import jmri.jmrix.ieee802154.xbee.XBeeConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeSensor;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeSensorManager
extends AbstractSensorManager
implements IIOSampleReceiveListener {
    protected XBeeTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeSensorManager.class);

    public XBeeSensorManager(XBeeConnectionMemo memo) {
        super(memo);
        this.tc = (XBeeTrafficController)memo.getTrafficController();
        this.tc.getXBee().addIOSampleListener((IIOSampleReceiveListener)this);
    }

    @Override
    @Nonnull
    public XBeeConnectionMemo getMemo() {
        return (XBeeConnectionMemo)this.memo;
    }

    @Override
    public void dispose() {
        this.tc.getXBee().removeIOSampleListener((IIOSampleReceiveListener)this);
        super.dispose();
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String name = this.addressFromSystemName(systemName);
        XBeeNode curNode = (XBeeNode)this.tc.getNodeFromName(name);
        if (curNode == null && (curNode = (XBeeNode)this.tc.getNodeFromAddress(name)) == null) {
            try {
                curNode = (XBeeNode)this.tc.getNodeFromAddress(Integer.parseInt(name));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Unable to convert " + systemName + " to XBee sensor address");
            }
        }
        int pin = this.pinFromSystemName(systemName);
        if (curNode != null && !curNode.getPinAssigned(pin)) {
            log.debug("Adding sensor to pin {}", (Object)pin);
            curNode.setPinBean(pin, new XBeeSensor(systemName, userName, this.tc));
            return (XBeeSensor)curNode.getPinBean(pin);
        }
        log.debug("Failed to create sensor {}", (Object)systemName);
        throw new IllegalArgumentException("Can't assign pin for " + systemName + " XBee sensor");
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        super.validateSystemNameFormat(name, locale);
        int pin = this.pinFromSystemName(name);
        if (pin < 0 || pin > 7) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidPin", name), Bundle.getMessage(locale, "SystemNameInvalidPin", name));
        }
        return name;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        if (this.tc.getNodeFromName(this.addressFromSystemName(systemName)) == null && this.tc.getNodeFromAddress(this.addressFromSystemName(systemName)) == null) {
            try {
                if (this.tc.getNodeFromAddress(Integer.parseInt(this.addressFromSystemName(systemName))) == null) {
                    return Manager.NameValidity.INVALID;
                }
                return this.pinFromSystemName(systemName) >= 0 && this.pinFromSystemName(systemName) <= 7 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
            }
            catch (NumberFormatException nfe) {
                log.debug("Unable to convert {} into the XBee node and pin format of nn:xx", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
        }
        return this.pinFromSystemName(systemName) >= 0 && this.pinFromSystemName(systemName) <= 7 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    public synchronized void ioSampleReceived(RemoteXBeeDevice remoteDevice, IOSample ioSample) {
        if (log.isDebugEnabled()) {
            log.debug("received io sample {} from {}", (Object)ioSample, (Object)remoteDevice);
        }
        XBeeNode node = (XBeeNode)this.tc.getNodeFromXBeeDevice(remoteDevice);
        for (int i = 0; i <= 8; ++i) {
            if (node.getPinAssigned(i) || !ioSample.hasDigitalValue(IOLine.getDIO((int)i))) continue;
            IOMode mode = IOMode.DISABLED;
            try {
                mode = remoteDevice.getIOConfiguration(IOLine.getDIO((int)i));
            }
            catch (TimeoutException toe) {
                log.debug("Timeout retrieving IO line mode for {} on {}", (Object)IOLine.getDIO((int)i), (Object)remoteDevice);
                mode = IOMode.DIGITAL_IN;
            }
            catch (InterfaceNotOpenException ino) {
                log.error("Interface Not Open retrieving IO line mode for {} on {}", (Object)IOLine.getDIO((int)i), (Object)remoteDevice);
            }
            catch (XBeeException xbe) {
                log.error("Error retrieving IO line mode for {} on {}", (Object)IOLine.getDIO((int)i), (Object)remoteDevice);
            }
            if (mode != IOMode.DIGITAL_IN) continue;
            node = (XBeeNode)this.tc.getNodeFromXBeeDevice(remoteDevice);
            String sName = this.getSystemNamePrefix() + node.getPreferedName() + ":" + i;
            XBeeSensor s = (XBeeSensor)this.getSensor(sName);
            if (s != null) continue;
            try {
                this.provideSensor(sName);
                if (!log.isDebugEnabled()) continue;
                log.debug("DIO {} enabled as sensor", (Object)sName);
                continue;
            }
            catch (IllegalArgumentException iae) {
                if (log.isDebugEnabled()) {
                    log.debug("Attempt to enable DIO {} as sensor failed", (Object)sName);
                }
                throw iae;
            }
        }
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return false;
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        String encoderAddress = this.addressFromSystemName(prefix + this.typeLetter() + curAddress);
        int input = this.pinFromSystemName(prefix + this.typeLetter() + curAddress);
        if (encoderAddress.equals("")) {
            throw new JmriException("I unable to determine hardware address");
        }
        return prefix + this.typeLetter() + encoderAddress + ":" + input;
    }

    private String addressFromSystemName(String systemName) {
        String encoderAddress;
        if (systemName.contains(":")) {
            int seperator = systemName.indexOf(":");
            encoderAddress = systemName.substring(this.getSystemPrefix().length() + 1, seperator);
        } else {
            encoderAddress = systemName.substring(this.getSystemPrefix().length() + 1, systemName.length() - 1);
        }
        if (log.isDebugEnabled()) {
            log.debug("Converted {} to hardware address {}", (Object)systemName, (Object)encoderAddress);
        }
        return encoderAddress;
    }

    private int pinFromSystemName(String systemName) {
        int input = 0;
        int iName = 0;
        if (systemName.contains(":")) {
            int seperator = systemName.indexOf(":");
            try {
                input = Integer.parseInt(systemName.substring(seperator + 1));
            }
            catch (NumberFormatException ex) {
                log.debug("Unable to convert {} into the cab and input format of nn:xx", (Object)systemName);
                return -1;
            }
        }
        try {
            iName = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
            input = iName % 10;
        }
        catch (NumberFormatException ex) {
            log.debug("Unable to convert {} Hardware Address to a number", (Object)systemName);
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug("Converted {} to pin number{}", (Object)systemName, (Object)input);
        }
        return input;
    }

    @Override
    public void deregister(@Nonnull Sensor s) {
        super.deregister(s);
        String systemName = s.getSystemName();
        String name = this.addressFromSystemName(systemName);
        int pin = this.pinFromSystemName(systemName);
        XBeeNode curNode = (XBeeNode)this.tc.getNodeFromName(name);
        if (curNode == null && (curNode = (XBeeNode)this.tc.getNodeFromAddress(name)) == null) {
            try {
                curNode = (XBeeNode)this.tc.getNodeFromAddress(Integer.parseInt(name));
            }
            catch (NumberFormatException nfe) {
                curNode = null;
            }
        }
        if (curNode != null) {
            if (curNode.removePinBean(pin, s)) {
                log.debug("Removing sensor from pin {}", (Object)pin);
            } else {
                log.debug("Failed to removing sensor from pin {}", (Object)pin);
            }
        }
    }

    @Override
    public boolean isPullResistanceConfigurable() {
        return true;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddEntryToolTip");
    }
}

