/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.XBeeDevice;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.listeners.IDataReceiveListener;
import com.digi.xbee.api.listeners.IModemStatusReceiveListener;
import com.digi.xbee.api.listeners.IPacketReceiveListener;
import com.digi.xbee.api.models.ModemStatusEvent;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.packet.XBeePacket;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.swing.SwingUtilities;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.AbstractNode;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.ieee802154.IEEE802154Listener;
import jmri.jmrix.ieee802154.IEEE802154Message;
import jmri.jmrix.ieee802154.IEEE802154Node;
import jmri.jmrix.ieee802154.IEEE802154Reply;
import jmri.jmrix.ieee802154.IEEE802154TrafficController;
import jmri.jmrix.ieee802154.xbee.XBeeAdapter;
import jmri.jmrix.ieee802154.xbee.XBeeInterface;
import jmri.jmrix.ieee802154.xbee.XBeeListener;
import jmri.jmrix.ieee802154.xbee.XBeeMessage;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeReply;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeTrafficController
extends IEEE802154TrafficController
implements IPacketReceiveListener,
IModemStatusReceiveListener,
IDataReceiveListener,
XBeeInterface {
    private XBeeDevice xbee = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeTrafficController.class);

    @Override
    public IEEE802154Message getIEEE802154Message(int length) {
        return null;
    }

    @Override
    protected AbstractMRReply newReply() {
        return new XBeeReply();
    }

    @Override
    public void connectPort(AbstractPortController p) {
        try {
            if (!(p instanceof XBeeAdapter)) {
                throw new IllegalArgumentException("Wrong adapter type specified when connecting to the port.");
            }
            this.configureLocalXBee((XBeeAdapter)p);
            this.resetLocalXBee();
        }
        catch (TimeoutException te) {
            log.error("Timeout during communication with Local XBee on communication start up. Error was {} ", (Object)te.getCause(), (Object)te);
        }
        catch (XBeeException xbe) {
            log.error("Exception during XBee communication start up. Error was {} ", (Object)xbe.getCause(), (Object)xbe);
        }
        this.startTransmitThread();
    }

    private void startTransmitThread() {
        this.xmtRunnable = () -> {
            block2: {
                try {
                    this.transmitLoop();
                }
                catch (Throwable e) {
                    if (this.threadStopRequest) break block2;
                    log.error("Transmit thread terminated prematurely by: {}", (Object)e, (Object)e);
                }
            }
        };
        this.xmtThread = ThreadingUtil.newThread(this.xmtRunnable);
        String[] packages = this.getClass().getName().split("\\.");
        this.xmtThread.setName((String)(packages.length >= 2 ? packages[packages.length - 2] + "." : "") + (packages.length >= 1 ? packages[packages.length - 1] : "") + " Transmit thread");
        this.xmtThread.setDaemon(true);
        this.xmtThread.setPriority(9);
        this.xmtThread.start();
    }

    private void configureLocalXBee(XBeeAdapter p) throws XBeeException {
        this.xbee = new XBeeDevice((IConnectionInterface)p);
        this.xbee.open();
        this.xbee.setReceiveTimeout(200);
        this.xbee.addPacketListener((IPacketReceiveListener)this);
        this.xbee.addModemStatusListener((IModemStatusReceiveListener)this);
        this.xbee.addDataListener((IDataReceiveListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT", "WA_NOT_IN_LOOP"}, justification="The unconditional wait outside of a loop is used to allow the hardware to react to a reset request.")
    private void resetLocalXBee() throws XBeeException {
        this.xbee.reset();
        try {
            XBeeTrafficController xBeeTrafficController = this;
            synchronized (xBeeTrafficController) {
                this.wait(2000L);
            }
        }
        catch (InterruptedException e) {
            log.debug("timeout interupted after reset request");
        }
    }

    @Override
    protected synchronized void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        log.trace("forwardToPort message: [{}]", (Object)m);
        if (log.isDebugEnabled()) {
            log.debug("forwardToPort message: [{}]", (Object)m);
        }
        if (!(m instanceof XBeeMessage)) {
            throw new IllegalArgumentException();
        }
        XBeeMessage xbm = (XBeeMessage)m;
        this.mLastSender = reply;
        AbstractMRTrafficController.XmtNotifier r = new AbstractMRTrafficController.XmtNotifier(m, this.mLastSender, this);
        SwingUtilities.invokeLater(r);
        this.sendWithErrorHandling(xbm);
    }

    private void sendWithErrorHandling(XBeeMessage xbm) {
        try {
            log.trace("Sending message {}", (Object)xbm);
            this.sendXBeePacketAsync(xbm.getXBeeRequest());
        }
        catch (XBeeException xbe) {
            log.error("Error Sending message to XBee {}", (Object)xbe, (Object)xbe);
        }
    }

    private void sendXBeePacketAsync(XBeeAPIPacket xBeeAPIPacket) throws XBeeException {
        log.trace("Sending XBeeAPIPacket +{}", (Object)xBeeAPIPacket.toPrettyString());
        this.xbee.sendPacketAsync((XBeePacket)xBeeAPIPacket);
    }

    @Override
    protected AbstractMRMessage pollMessage() {
        if (this.numNodes <= 0) {
            return null;
        }
        XBeeMessage msg = null;
        if (this.getNode(this.curSerialNodeIndex).getSensorsActive()) {
            msg = XBeeMessage.getForceSampleMessage(((XBeeNode)this.getNode(this.curSerialNodeIndex)).getPreferedTransmitAddress());
        }
        this.curSerialNodeIndex = (this.curSerialNodeIndex + 1) % this.numNodes;
        return msg;
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return null;
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        return null;
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return null;
    }

    @Override
    public void receiveLoop() {
    }

    @Override
    public void registerNode(AbstractNode node) {
        if (!(node instanceof XBeeNode)) {
            throw new IllegalArgumentException("Attempt to register node of incorrect type for this connection");
        }
        super.registerNode(node);
        XBeeNode xbnode = (XBeeNode)node;
        xbnode.setTrafficController(this);
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="synchronized method provides locking")
    public synchronized void deleteNode(XBeeNode node) {
        int index = 0;
        for (int i = 0; i < this.numNodes; ++i) {
            if (this.nodeArray[i] != node) continue;
            index = i;
        }
        if (index == this.curSerialNodeIndex) {
            log.warn("Deleting the serial node active in the polling loop");
        }
        --this.numNodes;
        if (index < this.numNodes) {
            for (int j = index; j < this.numNodes; ++j) {
                this.nodeArray[j] = this.nodeArray[j + 1];
            }
        }
        this.nodeArray[this.numNodes] = null;
        this.getXBee().getNetwork().addRemoteDevice(node.getXBee());
    }

    public void packetReceived(XBeePacket response) {
        log.debug("packetReceived called with {}", (Object)response);
    }

    public void modemStatusEventReceived(ModemStatusEvent modemStatusEvent) {
        log.debug("modemStatusEventReceived called with event {} ", (Object)modemStatusEvent);
    }

    public void dataReceived(com.digi.xbee.api.models.XBeeMessage xbm) {
        log.debug("dataReceived called with message {} ", (Object)xbm);
    }

    @Override
    public IEEE802154Node newNode() {
        return new XBeeNode();
    }

    @Override
    public void addXBeeListener(XBeeListener l) {
        this.addListener(l);
    }

    @Override
    public void removeXBeeListener(XBeeListener l) {
        this.addListener(l);
    }

    @Override
    public void sendXBeeMessage(XBeeMessage m, XBeeListener l) {
        this.sendMessage(m, l);
    }

    @Override
    protected synchronized void sendMessage(AbstractMRMessage m, AbstractMRListener reply) {
        this.msgQueue.addLast(m);
        this.listenerQueue.addLast(reply);
        if (m != null) {
            log.debug("just notified transmit thread with message {}", (Object)m);
        }
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        try {
            ((XBeeListener)client).message((XBeeMessage)m);
        }
        catch (ClassCastException cce) {
            ((IEEE802154Listener)client).message((IEEE802154Message)m);
        }
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply r) {
        if (client instanceof XBeeListener) {
            ((XBeeListener)client).reply((XBeeReply)r);
        } else {
            ((IEEE802154Listener)client).reply((IEEE802154Reply)r);
        }
    }

    public synchronized AbstractNode getNodeFromName(String Name2) {
        log.debug("getNodeFromName called with {}", (Object)Name2);
        for (int i = 0; i < this.numNodes; ++i) {
            XBeeNode node = (XBeeNode)this.getNode(i);
            if (!node.getIdentifier().equals(Name2)) continue;
            return node;
        }
        return null;
    }

    public synchronized AbstractNode getNodeFromXBeeDevice(RemoteXBeeDevice device) {
        log.debug("getNodeFromXBeeDevice called with {}", (Object)device);
        for (int i = 0; i < this.numNodes; ++i) {
            XBeeNode node = (XBeeNode)this.getNode(i);
            RemoteXBeeDevice nodeXBee = node.getXBee();
            if (!nodeXBee.get16BitAddress().equals((Object)device.get16BitAddress()) || !nodeXBee.get64BitAddress().equals((Object)device.get64BitAddress())) continue;
            return node;
        }
        return null;
    }

    public XBeeDevice getXBee() {
        return this.xbee;
    }

    @Override
    protected void terminate() {
        if (this.xbee != null) {
            this.terminateThreads();
            this.xbee.close();
            this.xbee = null;
        }
    }
}

