/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.io.IOLine;
import com.digi.xbee.api.io.IOValue;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.ieee802154.xbee.XBeeConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeTurnout
extends AbstractTurnout {
    private XBeeNode node = null;
    private int pin;
    private int pin2 = -1;
    protected XBeeTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeTurnout.class);

    public XBeeTurnout(String systemName, String userName, XBeeTrafficController controller) {
        super(systemName, userName);
        this.tc = controller;
        this.init(systemName);
    }

    public XBeeTurnout(String systemName, XBeeTrafficController controller) {
        super(systemName);
        this.tc = controller;
        this.init(systemName);
    }

    /*
     * Unable to fully structure code
     */
    private void init(String id) {
        m = this.tc.getAdapterMemo();
        if (!(m instanceof XBeeConnectionMemo)) {
            XBeeTurnout.log.error("Memo associated with the traffic controller is not the right type");
            throw new IllegalArgumentException("Memo associated with the traffic controller is not the right type");
        }
        memo = (XBeeConnectionMemo)m;
        prefix = memo.getTurnoutManager().getSystemPrefix();
        if (id.contains(":")) {
            seperator = id.indexOf(":");
            seperator2 = id.indexOf(":", seperator + 1);
            try {
                nodeIdentifier = id.substring(prefix.length() + 1, seperator);
                this.node = (XBeeNode)this.tc.getNodeFromName(nodeIdentifier);
                if (this.node == null && (this.node = (XBeeNode)this.tc.getNodeFromAddress(nodeIdentifier)) == null) {
                    try {
                        this.node = (XBeeNode)this.tc.getNodeFromAddress(Integer.parseInt(nodeIdentifier));
                    }
                    catch (NumberFormatException nfe) {
                        this.node = null;
                        throw new IllegalArgumentException("Node not defined");
                    }
                }
                this.pin = Integer.parseInt(id.substring(seperator + 1, seperator2 > 0 ? seperator2 : id.length()));
                if (seperator2 <= 0) ** GOTO lbl36
                this.pin2 = Integer.parseInt(id.substring(seperator2 + 1));
            }
            catch (NumberFormatException ex) {
                XBeeTurnout.log.debug("Unable to convert {} into the cab and input format of nn:xx", (Object)id);
                throw new IllegalArgumentException("Unable to convert " + id + " into the cab and input format of nn:xx");
            }
        } else {
            try {
                nodeIdentifier = id.substring(prefix.length() + 1, id.length() - 1);
                address = Integer.parseInt(id.substring(prefix.length() + 1));
                this.node = (XBeeNode)this.tc.getNodeFromAddress(address / 10);
                this.pin = address % 10;
            }
            catch (NumberFormatException ex) {
                XBeeTurnout.log.debug("Unable to convert {} Hardware Address to a number", (Object)id);
                throw new IllegalArgumentException("Unable to convert " + id + " Hardware Address to a number");
            }
        }
lbl36:
        // 3 sources

        if (XBeeTurnout.log.isDebugEnabled()) {
            XBeeTurnout.log.debug("Created Turnout {} (NodeIdentifier {} D{}{})", new Object[]{id, nodeIdentifier, this.pin, this.pin2 > 0 ? " D" + this.pin2 : ""});
        }
    }

    @Override
    protected void forwardCommandChangeToLayout(int s) {
        try {
            if (s == 4 ^ this.getInverted()) {
                this.node.getXBee().setDIOValue(IOLine.getDIO((int)this.pin), IOValue.HIGH);
            } else {
                this.node.getXBee().setDIOValue(IOLine.getDIO((int)this.pin), IOValue.LOW);
            }
            if (this.pin2 >= 0) {
                if (s == 2 ^ this.getInverted()) {
                    this.node.getXBee().setDIOValue(IOLine.getDIO((int)this.pin), IOValue.HIGH);
                } else {
                    this.node.getXBee().setDIOValue(IOLine.getDIO((int)this.pin), IOValue.LOW);
                }
            }
        }
        catch (TimeoutException toe) {
            log.error("Timeout setting IO line value for turnout {} on {}", (Object)this.getUserName(), (Object)this.node.getXBee());
        }
        catch (InterfaceNotOpenException ino) {
            log.error("Interface Not Open setting IO line value for turnout {} on {}", (Object)this.getUserName(), (Object)this.node.getXBee());
        }
        catch (XBeeException xbe) {
            log.error("Error setting IO line value for turout {} on {}", (Object)this.getUserName(), (Object)this.node.getXBee());
        }
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean locked) {
    }
}

