/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee.configurexml;

import com.digi.xbee.api.AbstractXBeeDevice;
import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.configurexml.XmlAdapter;
import jmri.jmrix.AbstractStreamConnectionConfig;
import jmri.jmrix.AbstractStreamPortController;
import jmri.jmrix.configurexml.AbstractSerialConnectionConfigXml;
import jmri.jmrix.ieee802154.xbee.ConnectionConfig;
import jmri.jmrix.ieee802154.xbee.XBeeAdapter;
import jmri.jmrix.ieee802154.xbee.XBeeConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import jmri.util.StringUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfigXml
extends AbstractSerialConnectionConfigXml {
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfigXml.class);

    @Override
    protected void extendElement(Element e) {
        XBeeTrafficController xtc;
        try {
            XBeeConnectionMemo xcm = (XBeeConnectionMemo)this.adapter.getSystemConnectionMemo();
            xtc = (XBeeTrafficController)xcm.getTrafficController();
        }
        catch (NullPointerException npe) {
            if (log.isDebugEnabled()) {
                log.debug("No memo defined; no nodes to save.");
            }
            return;
        }
        try {
            XBeeNode node = (XBeeNode)xtc.getNode(0);
            int index = 1;
            while (node != null) {
                Element n = new Element("node");
                n.setAttribute("name", Integer.toString(node.getNodeAddress()));
                e.addContent((Content)n);
                n.addContent((Content)this.makeParameter("address", StringUtil.hexStringFromBytes(node.getUserAddress())));
                n.addContent((Content)this.makeParameter("PAN", StringUtil.hexStringFromBytes(node.getPANAddress())));
                n.addContent((Content)this.makeParameter("GUID", StringUtil.hexStringFromBytes(node.getGlobalAddress())));
                n.addContent((Content)this.makeParameter("name", node.getIdentifier()));
                n.addContent((Content)this.makeParameter("polled", node.getPoll() ? "yes" : "no"));
                AbstractStreamPortController pc = null;
                pc = node.getPortController();
                if (pc != null) {
                    n.addContent((Content)this.makeParameter("StreamController", pc.getClass().getName()));
                }
                AbstractStreamConnectionConfig cf = null;
                cf = node.getConnectionConfig();
                if (cf != null) {
                    n.addContent((Content)this.makeParameter("StreamConfig", cf.getClass().getName()));
                    String adapter = ConfigXmlManager.adapterName(cf);
                    log.debug("forward to {}", (Object)adapter);
                    try {
                        XmlAdapter x = (XmlAdapter)Class.forName(adapter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        n.addContent((Content)x.store(cf));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        log.error("Exception: ", (Throwable)ex);
                    }
                }
                node = (XBeeNode)xtc.getNode(index);
                ++index;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected Element makeParameter(String name, String value) {
        Element p = new Element("parameter");
        p.setAttribute("name", name);
        p.addContent(value);
        return p;
    }

    @Override
    protected void getInstance() {
        this.adapter = new XBeeAdapter();
    }

    @Override
    protected void getInstance(Object object) {
        this.adapter = ((ConnectionConfig)object).getAdapter();
    }

    @Override
    protected void unpackElement(Element shared, Element perNode) {
        List l = shared.getChildren("node");
        XBeeConnectionMemo xcm = (XBeeConnectionMemo)this.adapter.getSystemConnectionMemo();
        XBeeTrafficController xtc = (XBeeTrafficController)xcm.getTrafficController();
        for (Element n : l) {
            byte[] GUID2 = StringUtil.bytesFromHexString(this.findParmValue(n, "GUID"));
            XBee64BitAddress guid = new XBee64BitAddress(GUID2);
            byte[] addr = StringUtil.bytesFromHexString(this.findParmValue(n, "address"));
            XBee16BitAddress address = new XBee16BitAddress(addr);
            String Identifier = this.findParmValue(n, "name");
            RemoteXBeeDevice remoteDevice = new RemoteXBeeDevice((AbstractXBeeDevice)xtc.getXBee(), guid, address, Identifier);
            XBeeNode curNode = (XBeeNode)xtc.getNodeFromXBeeDevice(remoteDevice);
            if (curNode != null) {
                log.info("Read duplicate node {} from file", (Object)remoteDevice);
                continue;
            }
            try {
                Constructor<?> ctor;
                Class<?> T;
                Element connect;
                xtc.getXBee().getNetwork().addRemoteDevice(remoteDevice);
                XBeeNode node = new XBeeNode(remoteDevice);
                String polled = this.findParmValue(n, "polled");
                node.setPoll(polled.equals("yes"));
                xtc.registerNode(node);
                String streamController = this.findParmValue(n, "StreamController");
                String streamConfig = this.findParmValue(n, "StreamConfig");
                AbstractStreamPortController connectedController = null;
                AbstractStreamConnectionConfig connectedConfig = null;
                try {
                    connect = (Element)n.getChildren("connection").get(0);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    connect = null;
                }
                if (streamController != null) {
                    try {
                        T = Class.forName(streamController);
                        ctor = T.getConstructor(DataInputStream.class, DataOutputStream.class, String.class);
                        connectedController = (AbstractStreamPortController)ctor.newInstance(node.getIOStream().getInputStream(), node.getIOStream().getOutputStream(), "XBee Node " + node.getPreferedName());
                    }
                    catch (ClassNotFoundException cnfe) {
                        log.error("Unable to find class for stream controller : {}", (Object)streamController);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        log.error("Unable to construct Stream Port Controller for node.", (Throwable)ex);
                    }
                }
                if (streamConfig != null && connectedController != null) {
                    try {
                        T = Class.forName(streamConfig);
                        ctor = T.getConstructor(AbstractStreamPortController.class);
                        connectedConfig = (AbstractStreamConnectionConfig)ctor.newInstance(connectedController);
                    }
                    catch (ClassNotFoundException cnfe) {
                        log.error("Unable to find class for stream config: {}", (Object)streamConfig);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        log.error("Unable to construct Stream Port Configuration for node.", (Throwable)ex);
                    }
                }
                if (connect != null && connectedConfig != null) {
                    String className = connect.getAttributeValue("class");
                    try {
                        XmlAdapter adapter = (XmlAdapter)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        adapter.load(connect, connectedConfig);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        log.error("Unable to create {} for {}", new Object[]{className, shared, ex});
                    }
                    catch (RuntimeException | JmriConfigureXmlException ex) {
                        log.error("Unable to load {} into {}", new Object[]{shared, className, ex});
                    }
                }
                if (connectedConfig != null) {
                    node.connectPortController(connectedConfig);
                } else if (connectedController != null) {
                    node.connectPortController(connectedController);
                }
                if (node.getConnectionConfig() == null) continue;
                log.info("loaded {} onto node {}", (Object)node.getConnectionConfig(), (Object)node);
                log.info("manuf {} userName {} ", (Object)node.getConnectionConfig().getManufacturer(), (Object)node.getConnectionConfig().name());
            }
            catch (TimeoutException toe) {
                log.error("Timeout adding node {} from configuration file.", (Object)remoteDevice);
            }
            catch (XBeeException xbe) {
                log.error("Exception adding node {} from configuration file.", (Object)remoteDevice);
            }
        }
    }

    @Override
    protected void register() {
        this.register(new ConnectionConfig(this.adapter));
    }
}

