/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee.swing.nodeconfig;

import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.swing.nodeconfig.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignmentTableModel
extends AbstractTableModel {
    private XBeeNode curNode = null;
    public static final int BIT_COLUMN = 0;
    public static final int SYSNAME_COLUMN = 1;
    public static final int USERNAME_COLUMN = 2;
    private final String[] assignmentTableColumnNames = new String[]{Bundle.getMessage("HeadingBit"), Bundle.getMessage("HeadingSystemName"), Bundle.getMessage("HeadingUserName")};
    private final String free = Bundle.getMessage("AssignmentFree");
    private static final Logger log = LoggerFactory.getLogger(AssignmentTableModel.class);

    public void setNode(XBeeNode node) {
        this.curNode = node;
        this.fireTableDataChanged();
    }

    public void initTable(JTable assignmentTable) {
        TableColumnModel assignmentColumnModel = assignmentTable.getColumnModel();
        TableColumn bitColumn = assignmentColumnModel.getColumn(0);
        bitColumn.setMinWidth(20);
        bitColumn.setMaxWidth(40);
        bitColumn.setResizable(true);
        TableColumn sysColumn = assignmentColumnModel.getColumn(1);
        sysColumn.setMinWidth(75);
        sysColumn.setMaxWidth(100);
        sysColumn.setResizable(true);
        TableColumn userColumn = assignmentColumnModel.getColumn(2);
        userColumn.setMinWidth(90);
        userColumn.setMaxWidth(450);
        userColumn.setResizable(true);
    }

    @Override
    public String getColumnName(int c) {
        return this.assignmentTableColumnNames[c];
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 0) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return 8;
    }

    @Override
    public Object getValueAt(int r, int c) {
        int pin = r;
        try {
            switch (c) {
                case 0: {
                    return pin;
                }
                case 1: {
                    if (this.curNode == null) {
                        return this.free;
                    }
                    if (this.curNode.getPinAssigned(pin)) {
                        return this.curNode.getPinBean(pin).getSystemName();
                    }
                    return this.free;
                }
                case 2: {
                    if (this.curNode == null) {
                        return "";
                    }
                    if (this.curNode.getPinAssigned(pin)) {
                        return this.curNode.getPinBean(pin).getUserName();
                    }
                    return "";
                }
            }
            return "";
        }
        catch (NullPointerException npe) {
            log.debug("Caught NPE getting pin assignment for pin {}", (Object)pin);
            return "";
        }
    }

    @Override
    public void setValueAt(Object type, int r, int c) {
    }
}

