/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee.swing.nodeconfig;

import java.awt.event.ActionEvent;
import jmri.InstanceManager;
import jmri.jmrix.ieee802154.swing.nodeconfig.NodeConfigAction;
import jmri.jmrix.ieee802154.xbee.XBeeConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import jmri.jmrix.ieee802154.xbee.swing.nodeconfig.Bundle;
import jmri.jmrix.ieee802154.xbee.swing.nodeconfig.XBeeNodeConfigFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeNodeConfigAction
extends NodeConfigAction {
    private XBeeConnectionMemo xcm = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeNodeConfigAction.class);

    public XBeeNodeConfigAction(String s, XBeeConnectionMemo cm) {
        super(s, cm);
        if (cm == null) {
            try {
                this.xcm = InstanceManager.getList(XBeeConnectionMemo.class).get(0);
            }
            catch (IndexOutOfBoundsException | NullPointerException e) {
                log.debug("No XBee System Connection Memo available");
            }
        } else {
            this.xcm = cm;
        }
    }

    public XBeeNodeConfigAction() {
        this(Bundle.getMessage("ConfigureXbeeTitle"), (XBeeConnectionMemo)null);
    }

    public XBeeNodeConfigAction(String s) {
        this(s, (XBeeConnectionMemo)null);
    }

    public XBeeNodeConfigAction(XBeeConnectionMemo cm) {
        this(Bundle.getMessage("ConfigureXbeeTitle"), cm);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XBeeNodeConfigFrame f = new XBeeNodeConfigFrame((XBeeTrafficController)this.xcm.getTrafficController());
        try {
            f.initComponents();
        }
        catch (Exception ex) {
            log.error("Exception: {}", (Object)ex.toString());
        }
        f.setLocation(100, 30);
        f.setVisible(true);
    }
}

