/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.internal;

import jmri.AddressedProgrammerManager;
import jmri.CommandStation;
import jmri.Consist;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.implementation.AbstractConsistManager;
import jmri.implementation.DccConsist;
import jmri.implementation.NmraConsist;

public class InternalConsistManager
extends AbstractConsistManager {
    @Override
    public boolean isCommandStationConsistPossible() {
        return false;
    }

    @Override
    public boolean csConsistNeedsSeperateAddress() {
        return false;
    }

    @Override
    public Consist addConsist(LocoAddress address) {
        if (!(address instanceof DccLocoAddress)) {
            throw new IllegalArgumentException("address is not a DccLocoAddress object");
        }
        if (this.consistTable.containsKey(address)) {
            return (Consist)this.consistTable.get(address);
        }
        DccConsist consist = null;
        if (InstanceManager.getNullableDefault(CommandStation.class) != null) {
            consist = new NmraConsist((DccLocoAddress)address);
        } else if (InstanceManager.getNullableDefault(AddressedProgrammerManager.class) != null) {
            consist = new DccConsist((DccLocoAddress)address);
        }
        if (consist != null) {
            this.consistTable.put(address, consist);
            this.notifyConsistListChanged();
        }
        return consist;
    }
}

