/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.internal;

import java.util.Comparator;
import java.util.ResourceBundle;
import jmri.AddressedProgrammerManager;
import jmri.ConsistManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.LightManager;
import jmri.MeterManager;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.StringIOManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.debugthrottle.DebugThrottleManager;
import jmri.jmrix.internal.InternalConsistManager;
import jmri.jmrix.internal.InternalLightManager;
import jmri.jmrix.internal.InternalMeterManager;
import jmri.jmrix.internal.InternalReporterManager;
import jmri.jmrix.internal.InternalSensorManager;
import jmri.jmrix.internal.InternalStringIOManager;
import jmri.jmrix.internal.InternalTurnoutManager;
import jmri.managers.DefaultPowerManager;
import jmri.managers.DefaultProgrammerManager;
import jmri.progdebugger.DebugProgrammerManager;
import jmri.util.NamedBeanPreferNumericComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements InstanceManagerAutoDefault {
    boolean configured = false;
    boolean defaultInstanceType = false;
    private static final Logger log = LoggerFactory.getLogger(InternalSystemConnectionMemo.class);

    public InternalSystemConnectionMemo(String prefix, String name, boolean defaultInstanceType) {
        super(prefix, name);
        InstanceManager.store(this, InternalSystemConnectionMemo.class);
        this.register();
        this.defaultInstanceType = defaultInstanceType;
    }

    public InternalSystemConnectionMemo(String prefix, String name) {
        this(prefix, name, true);
    }

    public InternalSystemConnectionMemo(boolean defaultInstanceType) {
        this("I", "Internal", defaultInstanceType);
    }

    public InternalSystemConnectionMemo() {
        this(true);
    }

    public void configureManagers() {
        log.debug("Do configureManagers - doesn't pre-build anything");
        if (this.configured) {
            log.warn("configureManagers called for a second time", (Throwable)new Exception("traceback"));
        }
        this.configured = true;
    }

    public InternalSensorManager getSensorManager() {
        InternalSensorManager sensorManager = (InternalSensorManager)this.classObjectMap.get(SensorManager.class);
        if (sensorManager == null) {
            log.debug("Create InternalSensorManager \"{}\" by request", (Object)this.getSystemPrefix());
            sensorManager = new InternalSensorManager(this);
            this.store(sensorManager, SensorManager.class);
            InstanceManager.setSensorManager(sensorManager);
        }
        return sensorManager;
    }

    public InternalLightManager getLightManager() {
        InternalLightManager lightManager = (InternalLightManager)this.classObjectMap.get(LightManager.class);
        if (lightManager == null) {
            log.debug("Create InternalLightManager by request");
            lightManager = new InternalLightManager(this);
            this.store(lightManager, LightManager.class);
            InstanceManager.setLightManager(lightManager);
        }
        return lightManager;
    }

    public InternalReporterManager getReporterManager() {
        InternalReporterManager reporterManager = (InternalReporterManager)this.classObjectMap.get(ReporterManager.class);
        if (reporterManager == null) {
            log.debug("Create InternalReporterManager by request");
            reporterManager = new InternalReporterManager(this);
            this.store(reporterManager, ReporterManager.class);
            InstanceManager.setReporterManager(reporterManager);
        }
        return reporterManager;
    }

    public InternalTurnoutManager getTurnoutManager() {
        InternalTurnoutManager turnoutManager = (InternalTurnoutManager)this.classObjectMap.get(TurnoutManager.class);
        if (turnoutManager == null) {
            log.debug("Create InternalTurnoutManager \"{}\" by request", (Object)this.getSystemPrefix());
            turnoutManager = new InternalTurnoutManager(this);
            this.store(turnoutManager, TurnoutManager.class);
            InstanceManager.setTurnoutManager(turnoutManager);
        }
        return turnoutManager;
    }

    public InternalMeterManager getMeterManager() {
        InternalMeterManager meterManager = (InternalMeterManager)this.classObjectMap.get(MeterManager.class);
        if (meterManager == null) {
            log.debug("Create InternalMeterManager by request {}", (Object)this.getSystemPrefix());
            meterManager = new InternalMeterManager(this);
            InstanceManager.setMeterManager(meterManager);
        }
        return meterManager;
    }

    public InternalStringIOManager getStringIOManager() {
        InternalStringIOManager stringIOManager = (InternalStringIOManager)this.classObjectMap.get(StringIOManager.class);
        if (stringIOManager == null) {
            log.debug("Create InternalStringIOManager by request {}", (Object)this.getSystemPrefix());
            stringIOManager = new InternalStringIOManager(this);
            InstanceManager.setStringIOManager(stringIOManager);
        }
        return stringIOManager;
    }

    public DefaultPowerManager getPowerManager() {
        return (DefaultPowerManager)this.classObjectMap.computeIfAbsent(PowerManager.class, c -> {
            log.debug("Create DefaultPowerManager by request");
            DefaultPowerManager powerManager = new DefaultPowerManager(this);
            InstanceManager.store(powerManager, PowerManager.class);
            return powerManager;
        });
    }

    @Override
    public InternalConsistManager getConsistManager() {
        if (this.defaultInstanceType) {
            return null;
        }
        return (InternalConsistManager)this.classObjectMap.computeIfAbsent(ConsistManager.class, c -> {
            log.debug("Create InternalConsistManager by request");
            InternalConsistManager consistManager = new InternalConsistManager();
            InstanceManager.store(consistManager, ConsistManager.class);
            return consistManager;
        });
    }

    public DebugThrottleManager getThrottleManager() {
        if (this.defaultInstanceType) {
            return null;
        }
        return (DebugThrottleManager)this.classObjectMap.computeIfAbsent(ThrottleManager.class, c -> {
            log.debug("Create DebugThrottleManager by request");
            DebugThrottleManager throttleManager = new DebugThrottleManager(this);
            InstanceManager.setThrottleManager(throttleManager);
            return throttleManager;
        });
    }

    public DebugProgrammerManager getProgrammerManager() {
        if (this.defaultInstanceType) {
            return null;
        }
        return (DebugProgrammerManager)this.classObjectMap.computeIfAbsent(DefaultProgrammerManager.class, c -> {
            log.debug("Create DebugProgrammerManager by request");
            return new DebugProgrammerManager(this);
        });
    }

    @Override
    public boolean provides(Class<?> type) {
        if (this.getDisabled()) {
            return false;
        }
        if (!this.configured) {
            this.configureManagers();
        }
        if (type.equals(SensorManager.class)) {
            return true;
        }
        if (type.equals(LightManager.class)) {
            return true;
        }
        if (type.equals(ReporterManager.class)) {
            return true;
        }
        if (type.equals(StringIOManager.class)) {
            return true;
        }
        if (type.equals(TurnoutManager.class)) {
            return true;
        }
        if (!this.defaultInstanceType) {
            if (type.equals(PowerManager.class)) {
                return true;
            }
            if (type.equals(GlobalProgrammerManager.class)) {
                return this.getProgrammerManager().isGlobalProgrammerAvailable();
            }
            if (type.equals(AddressedProgrammerManager.class)) {
                return this.getProgrammerManager().isAddressedModePossible();
            }
            if (type.equals(ThrottleManager.class)) {
                return true;
            }
            if (type.equals(ConsistManager.class)) {
                return true;
            }
        }
        return super.provides(type);
    }

    @Override
    public <T> T get(Class<T> type) {
        if (this.getDisabled()) {
            return null;
        }
        if (!this.configured) {
            this.configureManagers();
        }
        if (type.equals(SensorManager.class)) {
            return (T)this.getSensorManager();
        }
        if (type.equals(LightManager.class)) {
            return (T)this.getLightManager();
        }
        if (type.equals(ReporterManager.class)) {
            return (T)this.getReporterManager();
        }
        if (type.equals(StringIOManager.class)) {
            return (T)this.getStringIOManager();
        }
        if (type.equals(TurnoutManager.class)) {
            return (T)this.getTurnoutManager();
        }
        if (!this.defaultInstanceType) {
            if (type.equals(PowerManager.class)) {
                return (T)this.getPowerManager();
            }
            if (type.equals(GlobalProgrammerManager.class)) {
                return (T)this.getProgrammerManager();
            }
            if (type.equals(AddressedProgrammerManager.class)) {
                return (T)this.getProgrammerManager();
            }
            if (type.equals(ThrottleManager.class)) {
                return (T)this.getThrottleManager();
            }
            if (type.equals(ConsistManager.class)) {
                return (T)this.getConsistManager();
            }
        }
        return super.get(type);
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return null;
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanPreferNumericComparator();
    }

    @Override
    public void dispose() {
        TurnoutManager turnoutManager;
        SensorManager sensorManager = (SensorManager)this.classObjectMap.get(SensorManager.class);
        if (sensorManager != null) {
            sensorManager.dispose();
        }
        if ((turnoutManager = (TurnoutManager)this.classObjectMap.get(TurnoutManager.class)) != null) {
            turnoutManager.dispose();
        }
        super.dispose();
    }
}

