/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ipocs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.List;
import jmri.jmrix.ipocs.IpocsClientListener;
import jmri.jmrix.ipocs.protocol.Message;
import jmri.jmrix.ipocs.protocol.packets.ConnectionRequestPacket;
import jmri.jmrix.ipocs.protocol.packets.ConnectionResponsePacket;
import jmri.jmrix.ipocs.protocol.packets.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpocsClientHandler
implements CompletionHandler<Integer, ByteBuffer> {
    private static final Logger log = LoggerFactory.getLogger(IpocsClientHandler.class);
    private final AsynchronousSocketChannel client;
    private String unitId;
    private final List<IpocsClientListener> clientListeners = new ArrayList<IpocsClientListener>();

    public String getUnitId() {
        return this.unitId;
    }

    public IpocsClientHandler(AsynchronousSocketChannel client) {
        this.client = client;
        ByteBuffer recvBuffer = ByteBuffer.allocate(256);
        client.read(recvBuffer, recvBuffer, this);
    }

    @Override
    public void completed(Integer bytesRead, ByteBuffer recvBuffer) {
        if (bytesRead == -1) {
            try {
                this.client.close();
                for (IpocsClientListener listener : this.clientListeners) {
                    listener.clientDisconnected(this);
                }
            }
            catch (IOException ex) {
                log.error("Unable to close client: {}", (Object)ex.getMessage());
            }
            return;
        }
        int currPos = recvBuffer.position();
        recvBuffer.rewind();
        Message msg = null;
        while (recvBuffer.position() < currPos && (msg = Message.parse(recvBuffer, currPos - recvBuffer.position())) != null) {
            block7: for (Packet pkt : msg.getPackets()) {
                switch (pkt.getId()) {
                    case 1: {
                        this.unitId = msg.getObjectName();
                        for (IpocsClientListener listener : this.clientListeners) {
                            listener.clientConnected(this);
                        }
                        Message response = new Message();
                        response.setObjectName(msg.getObjectName());
                        ConnectionResponsePacket respPkt = new ConnectionResponsePacket();
                        respPkt.setProtocolVersion(((ConnectionRequestPacket)pkt).getProtocolVersion());
                        response.getPackets().add(respPkt);
                        this.client.write(response.serialize());
                        continue block7;
                    }
                }
                for (IpocsClientListener listener : this.clientListeners) {
                    listener.onMessage(this, msg);
                }
            }
        }
        ByteBuffer newRecvBuffer = ByteBuffer.allocate(256);
        if (recvBuffer.position() < currPos) {
            int position = recvBuffer.position();
            newRecvBuffer.put(recvBuffer);
            newRecvBuffer.position(currPos - position);
        }
        this.client.read(newRecvBuffer, newRecvBuffer, this);
    }

    @Override
    public void failed(Throwable exc, ByteBuffer attachment) {
        try {
            this.client.close();
        }
        catch (IOException ex) {
            log.error("Error closing connection", (Throwable)ex);
        }
        for (IpocsClientListener listener : this.clientListeners) {
            listener.clientDisconnected(this);
        }
    }

    public void addClientListener(IpocsClientListener clientListener) {
        this.clientListeners.add(clientListener);
    }

    public void removeClientListener(IpocsClientListener clientListener) {
        this.clientListeners.remove(clientListener);
    }

    public void send(Message msg) {
        this.client.write(msg.serialize());
    }
}

