/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ipocs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrix.AbstractConnectionConfig;
import jmri.jmrix.ipocs.Bundle;
import jmri.jmrix.ipocs.IpocsPortController;
import jmri.jmrix.ipocs.IpocsSystemConnectionMemo;
import jmri.util.swing.JmriJOptionPane;

public class IpocsConnectionConfig
extends AbstractConnectionConfig {
    private IpocsPortController portController;
    private final JTextField portField = new JTextField(6);
    private final JLabel portFieldLabel = new JLabel();
    private boolean isDisabled = false;

    public IpocsConnectionConfig() {
        this.portField.setText("0");
    }

    public IpocsConnectionConfig(IpocsPortController portController) {
        this();
        this.portController = portController;
    }

    @Override
    public String name() {
        return "IPOCS Connection";
    }

    @Override
    protected void setInstance() {
        if (this.portController == null) {
            this.portController = new IpocsPortController(new IpocsSystemConnectionMemo());
            this.portController.configure();
        }
    }

    @Override
    public String getInfo() {
        return this.getAdapter().getCurrentPortName();
    }

    @Override
    public IpocsPortController getAdapter() {
        return this.portController;
    }

    @Override
    protected void checkInitDone() {
    }

    @Override
    public void updateAdapter() {
        this.getAdapter().setPort(Short.parseShort(this.portField.getText()));
        if (this.getAdapter().getSystemConnectionMemo() != null && !this.getAdapter().getSystemConnectionMemo().setSystemPrefix(this.systemPrefixField.getText())) {
            this.systemPrefixField.setText(this.getAdapter().getSystemConnectionMemo().getSystemPrefix());
            this.connectionNameField.setText(this.getAdapter().getSystemConnectionMemo().getUserName());
        }
    }

    @Override
    public void loadDetails(JPanel details) {
        int i;
        this._details = details;
        this._details.setLayout(this.gbLayout);
        this.setInstance();
        this.portField.setToolTipText(Bundle.getMessage("PORT_TOOLTIP"));
        this.portField.setEnabled(true);
        this.portField.setText(String.valueOf(this.getAdapter().getPort()));
        this.portFieldLabel.setText(Bundle.getMessage("PORT_LABEL"));
        if (this.getAdapter().getSystemConnectionMemo() != null) {
            this.systemPrefixField.setText(this.getAdapter().getSystemConnectionMemo().getSystemPrefix());
            this.connectionNameField.setText(this.getAdapter().getSystemConnectionMemo().getUserName());
            this.NUMOPTIONS += 2;
        }
        this.systemPrefixField.addActionListener(new SystemPrefixFieldActionListener());
        this.systemPrefixField.addFocusListener(new SystemPrefixFieldFocusListener());
        this.connectionNameField.addActionListener(new ConnectionNameFieldActionListener());
        this.connectionNameField.addFocusListener(new ConnectionNameFieldFocusListener());
        this.portField.addActionListener(new PortFieldActionListener());
        this.portField.addFocusListener(new PortFieldFocusListener());
        this.cR.gridy = i = super.addStandardDetails(this.portController, false, 1);
        this.cL.gridy = i;
        this.gbLayout.setConstraints(this.portFieldLabel, this.cL);
        this.gbLayout.setConstraints(this.portField, this.cR);
        this._details.add(this.portFieldLabel);
        this._details.add(this.portField);
    }

    @Override
    protected void showAdvancedItems() {
    }

    @Override
    public String getManufacturer() {
        return "IPOCSMR";
    }

    @Override
    public void setManufacturer(String manufacturer) {
        this.portController.setManufacturer(manufacturer);
    }

    @Override
    public String getConnectionName() {
        return "IPOCSMR";
    }

    @Override
    public boolean getDisabled() {
        return this.isDisabled;
    }

    @Override
    public void setDisabled(boolean disable) {
        this.isDisabled = disable;
    }

    public class PortFieldFocusListener
    implements FocusListener {
        @Override
        public void focusLost(FocusEvent e) {
            try {
                IpocsConnectionConfig.this.getAdapter().setPort(Short.parseShort(IpocsConnectionConfig.this.portField.getText()));
            }
            catch (NumberFormatException ex) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("UNABLE_PORT"));
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    public class PortFieldActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                IpocsConnectionConfig.this.getAdapter().setPort(Short.parseShort(IpocsConnectionConfig.this.portField.getText()));
            }
            catch (NumberFormatException ex) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("UNABLE_PORT"));
            }
        }
    }

    public class ConnectionNameFieldFocusListener
    implements FocusListener {
        @Override
        public void focusLost(FocusEvent e) {
            if (!IpocsConnectionConfig.this.getAdapter().getSystemConnectionMemo().setUserName(IpocsConnectionConfig.this.connectionNameField.getText())) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("UNABLE_CONNNAME"));
                IpocsConnectionConfig.this.connectionNameField.setText(IpocsConnectionConfig.this.getAdapter().getSystemConnectionMemo().getUserName());
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    public class ConnectionNameFieldActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (!IpocsConnectionConfig.this.getAdapter().getSystemConnectionMemo().setUserName(IpocsConnectionConfig.this.connectionNameField.getText())) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("UNABLE_CONNNAME"));
                IpocsConnectionConfig.this.connectionNameField.setText(IpocsConnectionConfig.this.getAdapter().getSystemConnectionMemo().getUserName());
            }
        }
    }

    public class SystemPrefixFieldFocusListener
    implements FocusListener {
        @Override
        public void focusLost(FocusEvent e) {
            if (!IpocsConnectionConfig.this.getAdapter().getSystemConnectionMemo().setSystemPrefix(IpocsConnectionConfig.this.systemPrefixField.getText())) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("UNABLE_PREFIX"));
                IpocsConnectionConfig.this.systemPrefixField.setText(IpocsConnectionConfig.this.getAdapter().getSystemConnectionMemo().getSystemPrefix());
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    public class SystemPrefixFieldActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (!IpocsConnectionConfig.this.getAdapter().getSystemConnectionMemo().setSystemPrefix(IpocsConnectionConfig.this.systemPrefixField.getText())) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("UNABLE_PREFIX"));
                IpocsConnectionConfig.this.systemPrefixField.setText(IpocsConnectionConfig.this.getAdapter().getSystemConnectionMemo().getSystemPrefix());
            }
        }
    }
}

