/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ipocs;

import jmri.implementation.AbstractLight;
import jmri.jmrix.ipocs.IpocsClientHandler;
import jmri.jmrix.ipocs.IpocsClientListener;
import jmri.jmrix.ipocs.IpocsPortController;
import jmri.jmrix.ipocs.protocol.Message;
import jmri.jmrix.ipocs.protocol.enums.RqOutputCommand;
import jmri.jmrix.ipocs.protocol.packets.OutputStatusPacket;
import jmri.jmrix.ipocs.protocol.packets.Packet;
import jmri.jmrix.ipocs.protocol.packets.SetOutputPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpocsLight
extends AbstractLight
implements IpocsClientListener {
    private static final Logger log = LoggerFactory.getLogger(IpocsLight.class);
    private final IpocsPortController portController;

    public IpocsLight(IpocsPortController portController, String systemName, String userName) {
        super(systemName, userName);
        this.portController = portController;
        this.portController.addListener(this);
    }

    @Override
    protected void doNewState(int oldState, int newState) {
        Message order = new Message();
        order.setObjectName(this.getUserName());
        SetOutputPacket packet = new SetOutputPacket();
        switch (newState) {
            case 2: {
                packet.setCommand(RqOutputCommand.On);
                break;
            }
            case 4: {
                packet.setCommand(RqOutputCommand.Off);
                break;
            }
            case 1: {
                return;
            }
            default: {
                log.error("Unknown light order state");
                return;
            }
        }
        order.getPackets().add(packet);
        this.portController.send(order);
    }

    @Override
    public void setState(int newState) {
        log.debug("setState {} was {}", (Object)newState, (Object)this.mState);
        if (newState != 2 && newState != 4 && newState != 1) {
            throw new IllegalArgumentException("cannot set state value " + newState);
        }
        this.doNewState(this.mState, newState);
        this.notifyStateChange(this.mState, newState);
    }

    @Override
    public void clientConnected(IpocsClientHandler client) {
    }

    @Override
    public void clientDisconnected(IpocsClientHandler client) {
        this.setState(1);
    }

    @Override
    public void onMessage(IpocsClientHandler client, Message msg) {
        if (!msg.getObjectName().equals(super.getUserName())) {
            return;
        }
        for (Packet packet : msg.getPackets()) {
            block0 : switch (packet.getId()) {
                case 22: {
                    switch (((OutputStatusPacket)packet).getState()) {
                        case On: {
                            this.setState(2);
                            break block0;
                        }
                        case Off: {
                            this.setState(4);
                            break block0;
                        }
                    }
                    log.error("Unknown light state {}", (Object)((OutputStatusPacket)packet).getState().toString());
                    break;
                }
            }
        }
    }
}

