/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ipocs;

import jmri.implementation.AbstractSensor;
import jmri.jmrix.ipocs.IpocsClientHandler;
import jmri.jmrix.ipocs.IpocsClientListener;
import jmri.jmrix.ipocs.IpocsPortController;
import jmri.jmrix.ipocs.protocol.Message;
import jmri.jmrix.ipocs.protocol.packets.InputStatusPacket;
import jmri.jmrix.ipocs.protocol.packets.Packet;
import jmri.jmrix.ipocs.protocol.packets.RequestStatusPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpocsSensor
extends AbstractSensor
implements IpocsClientListener {
    private static final Logger log = LoggerFactory.getLogger(IpocsSensor.class);
    private final IpocsPortController portController;

    public IpocsSensor(IpocsPortController portController, String systemName, String userName) {
        super(systemName, userName);
        this.portController = portController;
        this.portController.addListener(this);
    }

    @Override
    public void requestUpdateFromLayout() {
        Message order = new Message();
        order.setObjectName(this.getUserName());
        RequestStatusPacket packet = new RequestStatusPacket();
        order.getPackets().add(packet);
        this.portController.send(order);
    }

    @Override
    public void clientConnected(IpocsClientHandler client) {
    }

    @Override
    public void clientDisconnected(IpocsClientHandler client) {
        this.setOwnState(1);
    }

    @Override
    public void onMessage(IpocsClientHandler client, Message msg) {
        if (!msg.getObjectName().equals(super.getUserName())) {
            return;
        }
        for (Packet packet : msg.getPackets()) {
            block0 : switch (packet.getId()) {
                case 20: {
                    switch (((InputStatusPacket)packet).getState()) {
                        case On: {
                            this.setOwnState(2);
                            break block0;
                        }
                        case Off: {
                            this.setOwnState(4);
                            break block0;
                        }
                        case Undefined: {
                            this.setOwnState(1);
                            break block0;
                        }
                    }
                    log.error("Unknown sensor state {}", (Object)((InputStatusPacket)packet).getState().toString());
                    break;
                }
            }
        }
    }
}

