/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ipocs;

import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import jmri.jmrix.ipocs.IpocsClientHandler;
import jmri.jmrix.ipocs.IpocsPortController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpocsSocketAcceptor
implements CompletionHandler<AsynchronousSocketChannel, Object> {
    private static final Logger log = LoggerFactory.getLogger(IpocsSocketAcceptor.class);
    private final AsynchronousServerSocketChannel serverSocket;
    private final IpocsPortController portController;

    public IpocsSocketAcceptor(IpocsPortController portController, AsynchronousServerSocketChannel serverSocket) {
        this.serverSocket = serverSocket;
        this.portController = portController;
    }

    @Override
    public void completed(AsynchronousSocketChannel result, Object attachment) {
        this.serverSocket.accept(null, this);
        log.info("Client connected");
        IpocsClientHandler c = new IpocsClientHandler(result);
        c.addClientListener(this.portController);
    }

    @Override
    public void failed(Throwable exc, Object attachment) {
        log.error("Unable to accept socket");
    }
}

