/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ipocs;

import jmri.implementation.AbstractTurnout;
import jmri.jmrix.ipocs.IpocsClientHandler;
import jmri.jmrix.ipocs.IpocsClientListener;
import jmri.jmrix.ipocs.IpocsPortController;
import jmri.jmrix.ipocs.protocol.Message;
import jmri.jmrix.ipocs.protocol.enums.RqPointsCommand;
import jmri.jmrix.ipocs.protocol.packets.Packet;
import jmri.jmrix.ipocs.protocol.packets.PointsStatusPacket;
import jmri.jmrix.ipocs.protocol.packets.ThrowPointsPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpocsTurnout
extends AbstractTurnout
implements IpocsClientListener {
    private static final Logger log = LoggerFactory.getLogger(IpocsTurnout.class);
    private final IpocsPortController portController;

    IpocsTurnout(IpocsPortController portController, String systemName, String userName) {
        super(systemName, userName);
        this.portController = portController;
        this.portController.addListener(this);
        this._validFeedbackNames = new String[]{"MONITORING"};
        this._validFeedbackModes = new int[]{8};
        this._validFeedbackTypes = 8;
        this._activeFeedbackType = 8;
        Message msg = portController.getLastStatus(userName);
        if (msg != null) {
            this.onMessage(null, msg);
        }
    }

    @Override
    protected void forwardCommandChangeToLayout(int s) {
        Message order = new Message();
        order.setObjectName(this.getUserName());
        ThrowPointsPacket packet = new ThrowPointsPacket();
        switch (s) {
            case 4: {
                packet.setCommand(RqPointsCommand.Left);
                break;
            }
            case 2: {
                packet.setCommand(RqPointsCommand.Right);
                break;
            }
            case 1: {
                return;
            }
            default: {
                log.error("Unknown turnout order state: {}", (Object)s);
                return;
            }
        }
        order.getPackets().add(packet);
        this.portController.send(order);
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean locked) {
    }

    @Override
    public void clientConnected(IpocsClientHandler client) {
    }

    @Override
    public void clientDisconnected(IpocsClientHandler client) {
        this.newKnownState(1);
    }

    @Override
    public void onMessage(IpocsClientHandler client, Message msg) {
        if (!msg.getObjectName().equals(super.getUserName())) {
            return;
        }
        block6: for (Packet packet : msg.getPackets()) {
            if (packet.getId() != 17) continue;
            switch (((PointsStatusPacket)packet).getState()) {
                case Left: {
                    this.newKnownState(4);
                    continue block6;
                }
                case Right: {
                    this.newKnownState(2);
                    continue block6;
                }
                case Moving: {
                    this.newKnownState(8);
                    continue block6;
                }
                case OutOfControl: {
                    this.newKnownState(1);
                    continue block6;
                }
            }
            log.error("Unknown turnout state {}", (Object)((PointsStatusPacket)packet).getState().toString());
        }
    }
}

